import Review from '../models/Review.js'
import cheerio from "cheerio";
import axios from 'axios';

const search = async (req, res, next) => {
    let DuplicateCheckReview = []
    if (!req.body.db) { DuplicateCheckReview = await Review.find({ keyword: req.query.keyword }) }
    if (!req.body.db && DuplicateCheckReview !== []) {
        req.review = DuplicateCheckReview
    } else {
        try {
            let reviews = []
            let url = "https://www.google.com/search?q=" + encodeURI(req.query.keyword) + `+site%3Atistory.com&start=${Number(req.query.index) * 10}`
            console.log(url)
            let response1 = await axios.get(url)
            let $1 = cheerio.load(response1.data);
            $1('.kCrYT').each(async function (i) {
                let title = $1(this).find('h3').text()
                let searchParams = new URLSearchParams($1(this).find('a').attr('href'));
                let link = searchParams.get("/url?q")
                let summary = $1(this).find('.s3v9rd').find('.s3v9rd').text()
                if (title) {
                    reviews[i] = { title: title, link: link, keyword: [req.query.keyword] }
                } else if (summary) {
                    reviews[i - 1] = { ...reviews[i - 1], summary: summary }
                    reviews = reviews.filter(e => e)
                }
            })
            req.review = reviews
        } catch (error) {
            console.log("6")
            console.log(error)
        }
    }
    next()
}

const save = async (req, res) => {
    req.review.forEach(async (reviews, i) => {
        const review = await Review.findOne({ link: reviews.link })
        if (review) {
            await Review.updateOne({ link: reviews.link }, { $push: { bookmark: req.query.keyword } })
            req.review[i] = ""
        }
        else {
            await new Review(reviews).save()
        }
    })
    console.log(req.review.length)
    req.review = req.review.filter(e => e)
    console.log(req.review.length)
    res.status(200).send({ review: req.review, db: true, index: Number(req.query.index) + 1 })
}
export default { search, save }
