/*global kakao*/
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Container, Row, Image, Col } from 'react-bootstrap';
import queryString from 'query-string'
import { Link } from 'react-router-dom';
import ohuh from '../ohuh-sm.PNG';
import catchErrors from '../utils/catchErrors';

function Place(props) {
  const [error, setError] = useState('')
  const [review, setReviews] = useState({ reviews: [], db: false, index: 0 })
  const { name, src, address } = queryString.parse(props.location.search)
  console.log(review)

  const getReview = async () => {
    try {
      setError('')
      const res = await axios({ url: `/api/review?keyword=${name}&index=${review.index}`, method: 'post', data: { db: review.db } })
      console.log("place res.data", res.data)
      setReviews({ reviews: [...review.reviews, ...res.data.review], db: res.data.db, index: res.data.index })
    } catch (error) {
      catchErrors(error, setError)
    }
  }


  useEffect(() => {
    getReview();
  }, []);


  return (
    <Container>

      <Link to="/"><Image style={{ margin: "1%" }} src={ohuh} /></Link>
      <div class="d-flex align-items-center p-3 my-3 text-white bg-info rounded shadow-sm">
          <h1 class="h6 mb-0 text-white">{name}</h1>
      </div>

      <div class="my-3 p-3 bg-white rounded shadow-sm">
        <h6 class="border-bottom pb-2 mb-0">관광지 정보</h6>
        <Row>
          <Col>
            <Image variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={src} />
          </Col>
          <Col>
            <div class="d-flex text-muted pt-3">
              <p class="pb-3 mb-0 lh-sm border-bottom">
                <strong class="d-block text-gray-dark">관광지 이름</strong>
                {name}
              </p>
            </div>
            <div class="d-flex text-muted pt-3">

              <p class="pb-3 mb-0 lh-sm border-bottom">
                <strong class="d-block text-gray-dark">관광지 주소</strong>
                {address}
              </p>
            </div>
          </Col>
        </Row>

        <small class="d-block text-end mt-3">
          <a href={`https://www.google.com/search?q=${name}&tbm=isch`}>사진 더보러가기</a>
        </small>
      </div>

      <div class="my-3 p-3 bg-white rounded shadow-sm">
        <h6 class="border-bottom pb-2 mb-0">관광지 후기</h6>
        {Array.isArray(review.reviews) ? review.reviews.map((review) => {
          return (
            <div class="d-flex text-muted pt-3">
              <div class="pb-3 mb-0 small lh-sm border-bottom w-100">
                <div class="d-flex justify-content-between">
                  <strong class="text-gray-dark">{review.title}</strong>
                  <a href={review.link}>블로그로 이동</a>
                </div>
                <span class="d-block">{review.summary}</span>
              </div>
            </div>
          )
        })
          : "리뷰가 없습니다."}



        <small class="d-block text-end mt-3">
          <a href="#" onClick={getReview} >리뷰 더보기</a>
        </small>
      </div>
    </Container>
  );
}

export default Place;
