import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Modal, Container, Row, Col, Button, Badge, Card, Accordion, Carousel } from 'react-bootstrap';

function Place(props) {
  const [reviews, setReviews] = useState()
  const [db, setDb] = useState(false)
  const getReview = () => {
    axios({ url: `/api/review?keyword=${props.place.name}`, method: 'post', data: { db: db } })
      .then(res => {
        console.log("place res.data", res.data)
        setReviews(res.data)
      })
      .catch(err => {
        console.log(err)
      })
  }

  useEffect(() => {
    getReview();
  }, [])

  return (
    <Modal {...props}
      size="xl"
      keyboard="true"
      variant="backdrop.in"
      // show={lgShow}
      // onHide={() => setLgShow(false)}
      aria-labelledby="example-modal-sizes-title-lg">
      <Modal.Header closeButton>
        <Modal.Title id="contained-modal-title-vcenter" style={{ fontSize: '40px' }}>
          {props.index + 1}. {props.place.name}
        </Modal.Title>
      </Modal.Header>
      <Modal.Body className="show-grid">
        <Container style={{ fontSize: '40px' }}>
          {Array.isArray(reviews) ? reviews.map((review, index) => {
            return (
              <Row className="mt-4">
                <a href={review.link}>{review.title}</a>
                <div>{review.summary}</div>
                <div>{review.content}</div>
              </Row>
            )
          })
            : "리뷰가 없습니다."}
        </Container>

      </Modal.Body>
      <Modal.Footer>
        <Button block onClick={props.onHide}>Close</Button>
      </Modal.Footer>
    </Modal>
  );
}

export default Place;
