import mongoose from 'mongoose'

const { String, ObjectId } = mongoose.Schema.Types

const PlaceSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true,
    },
    address: {
        type: String,
        required: true,
        unique: true,
    },
    img: {
        type: String,
        required: true,
        default: "https://t1.daumcdn.net/thumb/R600x0/?fname=http%3A%2F%2Ft1.daumcdn.net%2Fqna%2Fimage%2F4b035cdf8372d67108f7e8d339660479dfb41bbd",
    },
    time: {
        type: Array,
        required: true,
    },
    review: {
        type: ObjectId,
        ref: 'Review'
    }
}, {
    timestamps: true
})

export default mongoose.models.Place || mongoose.model('Place', PlaceSchema)