import Review from '../models/Review.js'
import cheerio from "cheerio";
import fs from 'fs'
import axios from 'axios';

const search = async (req, res, next) => {
    try {
        let reviews = []
        let content = []
        // Review.find()
        const url = "https://www.google.com/search?q=" + encodeURI(req.params.search) + "+site%3Atistory.com&page_no=1"
        const response1 = await axios.get(url)
        // console.log(response1.data)
        const $1 = cheerio.load(response1.data);
        $1('.kCrYT').each(async function (i) {
            const title = $1(this).find('h3').text()
            const searchParams = new URLSearchParams($1(this).find('a').attr('href'));
            const link = searchParams.get("/url?q")
            const summary = $1(this).find('.s3v9rd').find('.s3v9rd').text()
            content.push(getReview(link))
            if (title) {
                reviews[i] = { title: title, link: link }
            } else if (summary) {
                reviews[i - 1] = { ...reviews[i - 1], summary: summary }
                reviews = reviews.filter(e => e)
            }
        })
        let promiseReview = await Promise.all(content)
        promiseReview = promiseReview.filter(e => typeof (e) === 'string')
        reviews.forEach(async (review, i) => {
            review["content"] = promiseReview[i]
            const reviews = new Review(review).save()
        })

        res.send(reviews)
    } catch (error) {
        // console.log(error)
        // res.send(error)
    }
}

//***************네이버 크롤링 할 때 ********************* */
//     try {
//         let reviews = []
//         let content = []
//         const url = "https://search.naver.com/search.naver?where=view&sm=tab_jum&query=" + encodeURI('한라산')
//         const response1 = await axios.get(url)
//         // console.log(response1.data)
//         const $1 = cheerio.load(response1.data);
//         $1('._list').find('.total_wrap').each(async function (i) {
//             reviews[i] = { name: $1(this).find('.total_tit').text(), summery: $1(this).find('.dsc_txt').text(), link: $1(this).find('.total_tit').attr('href') }
//         })
//         res.send(reviews)
//     } catch (error) {
//         console.log(error)
//         res.send(error)
//     }
// }

const getReview = async (link) => {
    if (link) {
        let content = '없음'
        const res = await axios.get(link)
        const $2 = cheerio.load(res.data);
        if ($2('.tt_article_useless_p_margin').text()) {
            content = $2('.tt_article_useless_p_margin').text()
        }
        return content
    }
}

export default { search }