import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Modal, Container, Row, Button, } from 'react-bootstrap';

function Place(props) {
  const [reviews, setReviews] = useState([{ title: "", link: "", summery: "", content: "" }])
  const getReview = () => {
    axios.get(`/api/review/${props.search.name}`)//review를 서버에 연결해서
      .then(res => {s
        console.log("place res.data", res.data)
        setReviews(res.data)
      })
      .catch(err => {
        console.log(err)
      })
  }

  useEffect(() => {
    getReview();
  }, [])

  return (
    <Modal {...props}
      size="xl"
      keyboard="true"
      variant="backdrop.in"
      aria-labelledby="example-modal-sizes-title-lg">
      <Modal.Header closeButton>
        <Modal.Title id="contained-modal-title-vcenter" style={{ fontSize: '40px' }}>
          {props.index + 1}. {props.search.name}
        </Modal.Title>
      </Modal.Header>
      <Modal.Body className="show-grid">
        <Container style={{ fontSize: '40px' }}>
          {reviews.map((review, index) => {
            return (
              <Row className="mt-4">
                <a href={review.link}>{review.title}</a>
                <div>{review.summary}</div>
                <div>{review.content}</div>
              </Row>
            )
          })}
        </Container>

      </Modal.Body>
      <Modal.Footer>
        <Button block onClick={props.onHide}>Close</Button>
      </Modal.Footer>
    </Modal>
  );
}

export default Place;
