import React, { useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh-sm.PNG';
import Place from './Components/Place';
import halla from './halla.jpg';
import { Container, Row, Card, Image, InputGroup, FormControl, Button, Form } from 'react-bootstrap';

function Search(props) {
    const [state, setState] = useState(false);
    const [search, setSearch] = useState(props.location.state.id);
    const [modalShow, setModalShow] = useState(false);

    if (state !== false) {
        return <Redirect to={{
          pathname: `/search/${search}`,
          state: { id: search },
        }} />;
      }

    const handleChange = (e) => {
        setSearch(e.target.value);
    }

    const handleSubmit = (e) => {
        setState(true);
    }
    return (
        <Container className="mt-3">
            <Row className="" >
                <InputGroup size="lg">
                    <Link to="/"><Image src={ohuh} /></Link>
                    <FormControl
                        placeholder="검색어를 입력하세요."
                        value={search}
                        aria-label="Large"
                        aria-describedby="inputGroup-sizing-sm"
                        onChange={handleChange}
                    />
                    <InputGroup.Append>
                        <Button variant="outline-secondary" onClick={handleSubmit}><Link to="/search">검색</Link></Button>
                    </InputGroup.Append>
                </InputGroup>
            </Row>
            <Form>
                <Row className="d-flex justify-content-between">
                    <Card style={{ width: '35rem' }}>
                        <Card.Img variant="top" src={halla} />
                        <Card.Body>
                            <Card.Title>한라산(hallasan)</Card.Title>
                            <Card.Text>
                                제주 서귀포시 토평동 산15-1 </Card.Text>
                                <Button variant="primary" onClick={() => setModalShow(true)}>한라산 자세히 살펴보기</Button>
                                <Place search={search} show={modalShow} onHide={() => setModalShow(false)} />
                        </Card.Body>
                    </Card>

                    <Card style={{ width: '35rem' }}>
                        <Card.Img variant="top" src={halla} />
                        <Card.Body>
                            <Card.Title>성산일출봉(sungsan)</Card.Title>
                            <Card.Text>
                                제주 서귀포시 성산읍 성산리 1 </Card.Text>
                                <Button variant="primary" onClick={() => setModalShow(true)}>성산일출봉 자세히 살펴보기</Button>
                                <Place search={search} show={modalShow} onHide={() => setModalShow(false)} />
                        </Card.Body>
                    </Card>
                </Row>
                <Row className="d-flex justify-content-between">
                    <Card style={{ width: '35rem' }}>
                        <Card.Img variant="top" src={halla} />
                        <Card.Body>
                            <Card.Title>해녀의 집(haenyeo)</Card.Title>
                            <Card.Text>
                                제주 서귀포시 성산읍 한도로 141-13지번오조리 3 오조해녀의집 </Card.Text>
                                <Button variant="primary" onClick={() => setModalShow(true)}>해녀의 집 자세히 살펴보기</Button>
                                <Place search={search} show={modalShow} onHide={() => setModalShow(false)} />
                        </Card.Body>
                    </Card>

                    <Card style={{ width: '35rem' }}>
                        <Card.Img variant="top" src={halla} />
                        <Card.Body>
                            <Card.Title>오설록 티 뮤지엄(osulloc)</Card.Title>
                            <Card.Text>
                                제주 서귀포시 안덕면 신화역사로 15 오설록지번서광리 1235-1 오설록 </Card.Text>
                                <Button variant="primary" onClick={() => setModalShow(true)}>오설록 티 뮤지엄 자세히 살펴보기</Button>
                                <Place search={search} show={modalShow} onHide={() => setModalShow(false)} />
                        </Card.Body>
                    </Card>
                </Row>
            </Form>
        </Container>
    );
}

export default Search;