import React, { useEffect, useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh.PNG';
import { Container, Row, Col, Image, InputGroup, FormControl, Button } from 'react-bootstrap';

function App() {
  const [search, setSearch] = useState("");
  const [state, setState] = useState(false);

  if (state !== false) {
    return <Redirect to={{
      pathname: `/search/${search}`,
      state: { id: search },
    }} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
    console.log(e.target.value)
  }

  const handleSubmit = (e) => {
    setState(true);
  }



  return (
    <Container className="vh-100">
      <Row className="d-flex justify-content-md-center">
        <Image src={ohuh} />
        <InputGroup size="lg" xs={5}>
          <FormControl
            placeholder="검색어를 입력하세요."
            aria-label="Large"
            aria-describedby="inputGroup-sizing-sm"
            onChange={handleChange}
          />
          <InputGroup.Append>
            <Button variant="outline-secondary" onClick={handleSubmit}>검색</Button>
          </InputGroup.Append>
        </InputGroup>
        {/* <form onSubmit={handleSubmit}>
          <input className="" name="search" type="text" placeholder="검색어를 입력하세요." onChange={handleChange}></input>
          <Link to="/search"><button type="submit">검색</button></Link>
        </form> */}
      </Row>
    </Container>
  );
}

export default App;
