import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const ReviewSchema = new mongoose.Schema({
    link: {
        type: String,
        required: true,
    },
    address: {
        type: String,
        required: true,
        unique: true,
    },
    imag: {
        type: String,
        required: true,
        default: "https://t1.daumcdn.net/thumb/R600x0/?fname=http%3A%2F%2Ft1.daumcdn.net%2Fqna%2Fimage%2F4b035cdf8372d67108f7e8d339660479dfb41bbd",
    },
    time: {
        type: Array,
        required: true,
    },
}, {
    timestamps: true
})

export default mongoose.models.Review || mongoose.model('Review', ReviewSchema)