import express from 'express'
import connectDb from './utils/connectDb.js'
import placeRouter from './routes/place.routes.js'
import reviewRouter from './routes/review.routes.js'
import userRouter from "./routes/user.routes.js"
import authRouter from "./routes/auth.routes.js"

connectDb()

const app = express()

app.use(express.json())

app.use(placeRouter)
app.use(reviewRouter)
app.use(userRouter)
app.use(authRouter)

app.listen(3001, () => {
    console.log('Listening on port 3001')
})