import React, { useState, useEffect } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from '../ohuh.PNG';
import { Container, Row, Form, Image, InputGroup, Button, Col, Card, Nav } from 'react-bootstrap';
import axios from 'axios';
import { handleLogout, isAuthenticated } from '../utils/auth.js'

function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");
  const [recommend, setRecommend] = useState([{ name: " ", address: " ", img: " " }]);
  const [latest, setLatest] = useState([{ name: " ", address: " ", img: " " }]);


  useEffect(() => {
    getRecommend()
    getLatest()
  }, []);
  const user = isAuthenticated()

  if (state !== false) {
    return <Redirect to={`/search?keyword=${search}`} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  } //바뀌는 것이 있을때 이벤트 발생

  const handleSubmit = () => {
    setState(true);
  } //submit 버튼을 누르면 state 값을 true로 바뀐다

  const getRecommend = () => {
    axios.get(`/api/app/recommend`)
      .then(res => {
        setRecommend(res.data)
      })
      .catch(err => {
        console.log("APP RECOMMEND ERROR", err)
      })
  }

  const getLatest = () => {
    axios.get(`/api/app/lastest`)
      .then(res => {
        setLatest(res.data)
      })
      .catch(err => {
        console.log("APP LATEST ERROR", err)
      })
  }



  return (

    // <Container className="vh-100 ">
    //   <Col md={12} >
    //     <Row className="justify-content-center" >
    //       <Image src={ohuh} style={{ margin: "5%", marginTop : "3%" }} />
    //     </Row>
    //     <Row style={{ marginBottom: "5%" }}>
    <Container className="vh-100 ">
      <Col md={12} >
        <Nav className="justify-content-end" bg="#fff" variant="light" style={{}} >
          {user ? <Nav.Link onClick={() => handleLogout()}>로그아웃</Nav.Link>
            : (
              <>
                <Nav.Link href="/signup">회원가입</Nav.Link>
                <Nav.Link href="/login">로그인</Nav.Link>
              </>
            )}
          <Nav.Link href='/bookmark'>북마크</Nav.Link>
        </Nav>
        <Row className="justify-content-center">
        <Image src={ohuh} style={{ margin: "3%", marginTop : "3%" }} />
        </Row>
        <Row style={{ marginBottom: "5%" }}>
          <Form className="vw-100" onSubmit={handleSubmit}>
            <InputGroup >
              <Form.Control
                size="lg"
                placeholder="검색어를 입력하세요."
                aria-label="Large"
                aria-describedby="inputGroup-sizing-sm"
                onChange={handleChange}
              />
              <InputGroup.Append>
                <Button type='submit' variant="outline-secondary">검색</Button>
              </InputGroup.Append>
            </InputGroup>
          </Form>
        </Row>
        <Row  >
          <Col md={6} >
            <h1 className=" d-flex justify-content-center" style={{ marginBottom: "7%" }}>인기관광지</h1>
            <Card align="center" border="info" style={{ margin: "3%" }}>
              <Card.Title style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }} >{recommend.name}</Card.Title>
              <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={recommend.img} />
              <Card.Body >
                <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                  {recommend.address} </Card.Text>
                  <Link to={`/place?id=${1}&place=${recommend.name}`} >
                  <Button variant="primary"> {recommend.name} 자세히 살펴보기</Button>
                </Link>
              </Card.Body>
            </Card>
          </Col>

          <Col md={6} >
            <h1 className=" d-flex justify-content-center" style={{ marginBottom: "7%" }}>최근 검색관광지</h1>
            <Card align="center" border="info" style={{ margin: "3%" }}>
              <Card.Title style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }} >{latest.name}</Card.Title>
              <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={latest.img} />
              <Card.Body >
                <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                  {latest.address} </Card.Text>
                <Link to={`/place?id=${1}&place=${latest.name}`} >
                  <Button variant="primary"> {latest.name} 자세히 살펴보기</Button>
                </Link>
              </Card.Body>
            </Card>
          </Col>
        </Row>
      </Col>
    </Container>


  );
}

export default App;
