import React, { useState, useEffect } from 'react'
import { Col, Card, Container, Row, Button, Nav, Navbar, Image } from "react-bootstrap"
import axios from "axios"
import catchErrors from './utils/catchErrors.js'
import { isAuthenticated } from './utils/auth'
import * as Icon from 'react-bootstrap-icons';
import { Link } from 'react-router-dom'
import ohuh from './ohuh-sm.PNG';


const INIT_PAGE = {
    bookmark: []
}


function Bookmark() {
    const [page, setPage] = useState(INIT_PAGE)
    const [index, setIndex] = useState(1);
    const [error, setError] = useState('')
    const [state, setState] = useState(false);
    const [bookmark, setBookmark] = useState([false, false, false, false])
    const [pagePlace, setPagePlace] = useState([])
    const [showSet, setShowSet] = useState([false, false, false, false]);

    const user = isAuthenticated()

    async function getBookmark() {
        try {
            const response = await axios.get(`/api/users/bookmark?ID=${user}`)
            setPagePlace(response.data.bookmark)
        } catch (error) {
            catchErrors(error, setError)
        }
    }


    async function handleBookmark(index) {
        if (!bookmark[index]) {
            console.log(pagePlace[index])
            try {
                const response = await axios.put(`/api/users/bookmark?ID=${user}&place=${pagePlace[index]._id}`)
                alert(response.data, '북마크가 저장되었습니다.')
                const showArr = bookmark
                showArr[index] = true
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        } else {
            try {
                const response = await axios.delete(`/api/users/bookmark?ID=${user}`)
                alert(response.data, '저장된 북마크가 삭제되었습니다.')
                const showArr = bookmark
                showArr[index] = false
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        }
    }
    useEffect(() => {
        getBookmark()
    }, [])


    return (
        <Container>
            <Link to="/" className="d-flex justify-content-center">
                <Image style={{margin:"1%"}} src={ohuh} />
            </Link>
            <Navbar bg="info" variant="dark">
                <Navbar.Brand href="/">북마크</Navbar.Brand>
                <Nav className="mr-auto">
                    <Nav.Link href="/">Home</Nav.Link>
                </Nav>
            </Navbar>
            <Row className="d-flex flex-wrap">
                {console.log("#####################33", pagePlace)}
                {pagePlace.map((place, index) => {
                    return (
                        <Col key={index} md={6} >
                            <Card align="center" border="info" style={{ margin: "3%" }}>

                                <Card.Title className="d-flex justify-content-center" style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }} >{place.name}
                                    {user ?
                                        <Button
                                            variant={bookmark[index] ? "primary" : "light"}
                                            onClick={() => handleBookmark(index, place)}>
                                            <Icon.BookmarkStarFill size={35} />
                                            {console.log("bookmark", bookmark)}
                                            {console.log("bookmark[index]", bookmark[index])}</Button> : null}
                                </Card.Title>
                                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={place.img} />
                                <Card.Body >
                                    <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                                        {place.address} </Card.Text>
                                    <Button variant="info" onClick={() => {
                                        const showArr = [false, false, false, false]
                                        showArr[index] = true
                                        setShowSet(showArr)
                                    }}>{place.name} 자세히 살펴보기</Button>
                                    {/* <Place place={place} index={index} show={showSet[index]} onHide={() => setShowSet([false, false, false, false])} /> */}
                                </Card.Body>
                            </Card>
                        </Col>
                    )
                })}


            </Row>
        </Container >
    )
}

export default Bookmark


    // async function handleSubmit(e){
        //     setState(true);  //버튼이 눌려서 handlesubmit이될때 setState값이 true로 바뀐다
    //     try { //respons 서버에 post로 요청하여 데이터를 받아온다
    //         const response = await axios.post('/api/users/bookmark', page)
    //         setSuccess(true)
    //     } catch (error) {
    //         console.log(error)
    //         catchErrors(error, setError)
    //     }
    // }

    // useEffect(() => {
    //     getBookmark(user)
    // }, [user])