import mongoose from 'mongoose'

const { String } = mongoose.Schema.Types

const ReviewSchema = new mongoose.Schema({
    link: {
        type: String,
        required: true,
    },
    content: {
        type: String,
        required: true,
        unique: true,
    },
    keyword: {
        type: Array,
        required: true,
    },
    time: {
        type: Array,
        required: true,
    },
}, {
    timestamps: true
})

export default mongoose.models.Review || mongoose.model('Review', ReviewSchema)