import React, { useState, useEffect } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from '../ohuh.PNG';
import { Container, Row, Form, Image, InputGroup, Button, Col, Card, Nav } from 'react-bootstrap';
import axios from 'axios';
import { handleLogout, isAuthenticated } from '../utils/auth.js'

function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");
  const [recommend, setRecommend] = useState([{ name: " ", address: " ", img: " " }]);
  const [latest, setLatest] = useState([{ name: " ", address: " ", img: " " }]);


  useEffect(() => {
    getRecommend()
    getLatest()
  }, []);
  const user = isAuthenticated()

  if (state !== false) {
    return <Redirect to={`/search?keyword=${search}`} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  } //바뀌는 것이 있을때 이벤트 발생

  const handleSubmit = () => {
    setState(true);
  } //submit 버튼을 누르면 state 값을 true로 바뀐다

  const getRecommend = () => {
    axios.get(`/api/app/recommend`)
      .then(res => {
        setRecommend(res.data)
      })
      .catch(err => {
        console.log("APP RECOMMEND ERROR", err)
      })
  }

  const getLatest = () => {
    axios.get(`/api/app/lastest`)
      .then(res => {
        setLatest(res.data)
      })
      .catch(err => {
        console.log("APP LATEST ERROR", err)
      })
  }



  return (
    <>
      <style type="text/css">
        {`
                         .nav-link{
                  color: #17a2b8;
                }
              
                `}
      </style>
      <Container className="vh-100 ">
        <Col xs={12} >
          <Nav className="justify-content-end" bg="#fff" variant="light" id="nav">
            {user ? <>
              <Nav.Link onClick={() => handleLogout()}>로그아웃</Nav.Link>
              <Nav.Link href='/bookmark'>북마크</Nav.Link>
            </>
              : (
                <>
                  <Nav.Link href="/signup">회원가입</Nav.Link>
                  <Nav.Link href="/login">로그인</Nav.Link>
                </>
              )}
          </Nav>
          <Row className="justify-content-center" md={2}>
            <Col className="d-flex justify-content-center">
              <Image src={ohuh} style={{ margin: "3%", marginTop: "3%" }} fluid />
            </Col>
          </Row>
          <Row style={{ marginBottom: "5%" }}>
            <Form className="vw-100" onSubmit={handleSubmit}>
              <InputGroup >
                <Form.Control
                  size="lg"
                  placeholder="검색어를 입력하세요."
                  aria-label="Large"
                  aria-describedby="inputGroup-sizing-sm"
                  onChange={handleChange}
                />
                <InputGroup.Append  >
                  <Button type='submit' variant="outline-secondary">검색</Button>
                </InputGroup.Append>
              </InputGroup>
            </Form>
          </Row>

          <Row xs={6}>
            <Col md={6} xs={12}>
              <Card border="info" style={{ margin: "2%" }}>
                <Card.Title style={{ margin: "0", paddingTop: "3%", fontSize: '200%', fontWeight: 'bold' }} >
                  <Row style={{ fontSize: "60%", marginLeft: "7%" }}><strong class="border p-2 text-danger mb-2">인기관광지</strong></Row>
                  <Row style={{ fontSize: "100%", marginLeft: "8%" }}>{recommend.name}</Row></Card.Title>
                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={recommend.img} />
                <Card.Body style={{ paddingTop: "0" }} >
                  <Card.Text style={{ margin: "0", overflow: 'auto', fontSize: '120%', width: '100%', height: "65px" }} >
                    {recommend.address} </Card.Text>
                    <Link to={`/place?name=${recommend.name}&src=${recommend.img}&address=${recommend.address}`} >
                    <Button variant="info"> {recommend.name} 자세히 살펴보기</Button>
                  </Link>
                </Card.Body>
              </Card>
            </Col>

            <Col md={6} xs={12}>
              <Card border="info" style={{ margin: "2%" }} >
                <Card.Title style={{ margin: "0", paddingTop: "3%", fontSize: '200%', fontWeight: 'bold' }} >
                  <Row style={{ fontSize: "60%", marginLeft: "7%" }}><strong class="border p-2 text-success mb-2">최근 검색 관광지</strong></Row>
                  <Row style={{ fontSize: "100%", marginLeft: "8%" }}>{latest.name}</Row></Card.Title>
                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={latest.img} />
                <Card.Body style={{ paddingTop: "0" }}>
                  <Card.Text style={{ margin: "0", overflow: 'auto', fontSize: '120%', width: '100%', height: "65px" }} >
                    {latest.address} </Card.Text>
                    <Link to={`/place?name=${latest.name}&src=${latest.img}&address=${latest.address}`} >
                    <Button variant="info"> {latest.name} 자세히 살펴보기</Button>
                  </Link>
                </Card.Body>
              </Card>
            </Col>
          </Row>
        </Col>
      </Container>
    </>
  );
}

export default App;
