import React, { useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh-sm.PNG';
import Place from './Components/Place';
import { Container, Form, Row, Col, Card, Image, InputGroup, FormControl, Button, Pagination } from 'react-bootstrap';

function Search(props) {
    const [state, setState] = useState(false);
    const [search, setSearch] = useState(props.location.state.id);
    const [modalShow, setModalShow] = useState(false);

    const places = [{
        name: "한라산(hallasan)",
        address: "제주 서귀포시 토평동 산15-1",
        img: "https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg/269px-KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg",
    }, {
        name: "성산일출봉(sungsan)",
        address: "제주 서귀포시 성산읍 성산리 1",
        img: "https://www.jeju.go.kr/pub/site/geopark/images/sub/sub03/02%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84%EC%9D%B4%EC%95%BC%EA%B8%B0/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84_%EC%84%B1%EC%82%B0%EC%9D%BC%EC%B6%9C%EB%B4%89/1412402261.jpg",
    }, {
        name: "해녀의 집(haenyeo)",
        address: "제주 서귀포시 성산읍 한도로 141-13지번오조리 3 오조해녀의집",
        img: "https://mblogthumb-phinf.pstatic.net/MjAxNjExMTdfMTc0/MDAxNDc5MzU3ODU0ODQy.KZYXCjzsXT3rCsE4HXBfxyCg2buvluBvN_7NxVp7BSwg.loJc89d8JjGXdNCn-4yMd7aMWPjfrZn21TI9Hyzemkog.JPEG.icocam11/20161010_100205.jpg?type=w800",
    }, {
        name: "오설록 티 뮤지엄(osulloc)",
        address: "제주 서귀포시 안덕면 신화역사로 15 오설록지번서광리 1235-1 오설록",
        img: "https://lh3.googleusercontent.com/proxy/4u4wDLh1sQwCUQsLQbyAUND9Y9x_gBL_Ikw5sbE8SKBF3yd0k_xgac58yPIkzfplB8RNHpvEcEROoVyzWx4SO9QnKj78SF8DKgAQMcAo_anM9CIKtt-zN-ZN5E2WqKJNah4zj205kUdMMEXL36HEk5SZp98oymRGhrBMNlZYsuCMSgB2hkI4F0JOWdTIYz8i8x1Y8YPOwGDbde18dO-gU_Ylu_J360jXO8m-Kr1Xi91vtFthfVWVC4QOHgJF01AWF_dSAOpSDQFTNlVwI0sFK9XInojCuKh2Z_xd0UhtV2TOqvOXsOxq2355QDzveD1y6fpmi5RI",
    }, {
        name: "오설록 티 뮤지엄(osulloc)",
        address: "제주 서귀포시 안덕면 신화역사로 15 오설록지번서광리 1235-1 오설록",
        img: "https://lh3.googleusercontent.com/proxy/4u4wDLh1sQwCUQsLQbyAUND9Y9x_gBL_Ikw5sbE8SKBF3yd0k_xgac58yPIkzfplB8RNHpvEcEROoVyzWx4SO9QnKj78SF8DKgAQMcAo_anM9CIKtt-zN-ZN5E2WqKJNah4zj205kUdMMEXL36HEk5SZp98oymRGhrBMNlZYsuCMSgB2hkI4F0JOWdTIYz8i8x1Y8YPOwGDbde18dO-gU_Ylu_J360jXO8m-Kr1Xi91vtFthfVWVC4QOHgJF01AWF_dSAOpSDQFTNlVwI0sFK9XInojCuKh2Z_xd0UhtV2TOqvOXsOxq2355QDzveD1y6fpmi5RI",
    }, {
        name: "해녀의 집(haenyeo)",
        address: "제주 서귀포시 성산읍 한도로 141-13지번오조리 3 오조해녀의집",
        img: "https://mblogthumb-phinf.pstatic.net/MjAxNjExMTdfMTc0/MDAxNDc5MzU3ODU0ODQy.KZYXCjzsXT3rCsE4HXBfxyCg2buvluBvN_7NxVp7BSwg.loJc89d8JjGXdNCn-4yMd7aMWPjfrZn21TI9Hyzemkog.JPEG.icocam11/20161010_100205.jpg?type=w800",
    }, {
        name: "성산일출봉(sungsan)",
        address: "제주 서귀포시 성산읍 성산리 1",
        img: "https://www.jeju.go.kr/pub/site/geopark/images/sub/sub03/02%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84%EC%9D%B4%EC%95%BC%EA%B8%B0/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84_%EC%84%B1%EC%82%B0%EC%9D%BC%EC%B6%9C%EB%B4%89/1412402261.jpg",
    }, {
        name: "한라산(hallasan)",
        address: "제주 서귀포시 토평동 산15-1",
        img: "https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg/269px-KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg",
    }]

    if (state !== false) {
        return <Redirect to={{
            pathname: `/search/${search}`,
            state: { id: search },
        }} />;
    }

    const handleChange = (e) => {
        setSearch(e.target.value);
    }

    const handleSubmit = (e) => {
        setState(true);
    }
    return (
        <Container>
            <Row className="mt-2 mb-2">
            <Form className="vw-100" onSubmit={handleSubmit}>
                <InputGroup size="lg">
                    <Link to="/"><Image src={ohuh} /></Link>
                    <FormControl
                        placeholder="검색어를 입력하세요."
                        value={search}
                        aria-label="Large"
                        aria-describedby="inputGroup-sizing-sm"
                        onChange={handleChange}
                    />
                    <InputGroup.Append>
                        <Button type="submit" variant="outline-secondary" >검색</Button>
                    </InputGroup.Append>
                </InputGroup>
                </Form>
            </Row>
            <div>
                <Row className="d-flex flex-wrap">
                    {places.map((place, index) => (
                        <Col key={index} md={6}>
                            <Card>
                                <Card.Img variant="top" src={place.img} />
                                <Card.Body>
                                    <Card.Title>{place.name}</Card.Title>
                                    <Card.Text>
                                        {place.address} </Card.Text>
                                    <Button variant="primary" onClick={() => setModalShow(true)}>{place.name} 자세히 살펴보기</Button>
                                    <Place search={place.name} show={modalShow} onHide={() => setModalShow(false)} />
                                </Card.Body>
                            </Card>
                        </Col>
                    ))}
                </Row>
            </div>
            <Row className="mt-2 d-flex justify-content-center">
                <Pagination>
                    <Pagination.First />
                    <Pagination.Prev />
                    {1 === 1 ? "" : <Pagination.Ellipsis />}
                    <Pagination.Item active>{1}</Pagination.Item>

                    <Pagination.Item>{2}</Pagination.Item>
                    <Pagination.Item>{3}</Pagination.Item>
                    <Pagination.Item>{4}</Pagination.Item>
                    <Pagination.Item>{5}</Pagination.Item>

                    <Pagination.Ellipsis />
                    <Pagination.Next />
                    <Pagination.Last />
                </Pagination>
            </Row>
        </Container>
    );
}

export default Search;