import React, { useState, useEffect } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh-sm.PNG';
import Place from './Components/Place';
import { Container, Form, Row, Col, Card, Image, InputGroup, FormControl, Button, Modal } from 'react-bootstrap';
import Paginations from './pagination.js';
import * as Icon from 'react-bootstrap-icons';
import axios from "axios";

function Search(props) {
    const endPage = 10;
    const [state, setState] = useState(false);
    const [index, setIndex] = useState(1);
    const [showSet, setShowSet] = useState([false, false, false, false]);
    const [search, setSearch] = useState(props.location.state.id);
    const [mobile, setMobile] = useState();
    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    useEffect(() => {
        if (window.innerWidth < 960) {
            setMobile(true)
        } else {
            setMobile(false)
        }
    }, []);

    const places = [{
        name: "한라산(hallasan)",
        address: "제주 서귀포시 토평동 산15-1",
        img: "data:image/png;base64,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",
        // img: "https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg/269px-KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg?size=200x200",
        // }, {
        //     name: "성산일출봉(sungsan)",
        //     address: "제주 서귀포시 성산읍 성산리 1",
        //     img: "https://www.jeju.go.kr/pub/site/geopark/images/sub/sub03/02%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84%EC%9D%B4%EC%95%BC%EA%B8%B0/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84/%EC%A7%80%EC%A7%88%EB%A7%88%EC%9D%84_%EC%84%B1%EC%82%B0%EC%9D%BC%EC%B6%9C%EB%B4%89/1412402261.jpg?400/400",
        // }, {
        //     name: "해녀의 집(haenyeo)",
        //     address: "제주 서귀포시 성산읍 한도로 141-13지번오조리 3 오조해녀의집",
        //     img: "https://mblogthumb-phinf.pstatic.net/MjAxNjExMTdfMTc0/MDAxNDc5MzU3ODU0ODQy.KZYXCjzsXT3rCsE4HXBfxyCg2buvluBvN_7NxVp7BSwg.loJc89d8JjGXdNCn-4yMd7aMWPjfrZn21TI9Hyzemkog.JPEG.icocam11/20161010_100205.jpg?type=w800",
        // }, {
        //     name: "오설록 티 뮤지엄(osulloc)",
        //     address: "제주 서귀포시 안덕면 신화역사로 15 오설록지번서광리 1235-1 오설록",
        //     img: "https://cdnweb01.wikitree.co.kr/webdata/editor/202007/01/img_20200701143323_2ced7627.webp",
        // }, {
        //     name: "오설록 티 뮤지엄(osulloc)",
        //     address: "제주 서귀포시 안덕면 신화역사로 15 오설록지번서광리 1235-1 오설록",
        //     img: "https://upload.wikimedia.org/wikipedia/commons/thumb/e/eb/KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg/269px-KOCIS_Halla_Mountain_in_Jeju-do_%286387785543%29.jpg",
    }]

    if (state !== false) {
        return <Redirect to={{
            pathname: `/search/${search}`,
            state: { id: search },
        }} />;
    }

    const handlePage = (num) => {
        setIndex(num);
    }

    // async function bookmarkSave() {
    //     await axios.put('/api/users', {userId:userId, bookmarkId:bookmarkId})
    // }

    const handleChange = (e) => {
        setSearch(e.target.value);
    }

    const handleSubmit = (e) => {
        setState(true);
    }

    function paginate(items, pageNumber, itemNumber) {
        const page = [];
        const startIndex = (pageNumber - 1) * itemNumber
        for (var i = 0; i < itemNumber; i++) {
            page.push(items[(startIndex + i)])
        }
        return page
    }

    const pagePlace = paginate(places, index, 1)

    return (
        <Container >
            <Link to="/" className="d-flex justify-content-center"><Image src={ohuh} /></Link>
            <Row className="mb-2" className="d-flex justify-content-center">
                <Form style={{ width: "90vw" }} onSubmit={handleSubmit}>
                    <InputGroup size="lg">
                        <Link to="/">
                            <Col>
                                {/* <Image src={ohuh} fluid width="130px" /> */}
                            </Col>
                        </Link>
                        <FormControl
                            placeholder="검색어를 입력하세요."
                            value={search}
                            aria-label="Large"
                            aria-describedby="inputGroup-sizing-sm"
                            onChange={handleChange}
                        />
                        <InputGroup.Append>
                            <Button type="submit" variant="outline-secondary" style={{ maxHeight: "8vh", maxWidth: "14vh" }} >검색</Button>
                        </InputGroup.Append>
                    </InputGroup>
                </Form>
            </Row>
            <Row className="d-flex flex-wrap">
                {pagePlace.map((place, index) => {
                    return (
                        <Col key={index} md={6} >
                            <Card align="center" border="info" style={{ margin: "3%" }}>
                                <Button variant="outline-info" style={{ marginLeft: "60vh" }} onClick={handleShow}><Icon.BookmarkStar size={30} />  <Modal
                                    show={show}
                                    onHide={handleClose}
                                    backdrop="static"
                                    keyboard={false}
                                >
                                    <Modal.Header closeButton>
                                        <Modal.Title id="contained-modal-title-vcenter" style={{ fontSize: '30px' }}>북마크 추가됨
                                        </Modal.Title>
                                    </Modal.Header><Form>
                                        <Form.Group controlId="formBasicEmail">
                                            <Form.Label style={{ fontSize: '20px' }}>이름</Form.Label>
                                            <Form.Control type="email" />
                                            <Form.Text className="text-muted">
                                            </Form.Text>
                                        </Form.Group>

                                        {/* <Form.Group controlId="formBasicPassword">
                                            <Form.Label style={{ fontSize: '20px' }}>폴더</Form.Label>
                                            <Form.Control type="password" placeholder="Password" />
                                        </Form.Group> */}
                                        <Modal.Footer>
                                            <Button variant="primary" type="submit">저장</Button>
                                            <Button onClick={props.onHide}>삭제</Button>
                                        </Modal.Footer>
                                    </Form></Modal></Button>
                                <Card.Title style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }}>{place.name}
                                </Card.Title>
                                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={place.img} />
                                <Card.Body >
                                    <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                                        {place.address} </Card.Text>
                                    <Button variant="primary" onClick={() => {
                                        const showArr = [false, false, false, false]
                                        showArr[index] = true
                                        setShowSet(showArr)
                                    }}>{place.name} 자세히 살펴보기</Button>
                                    <Place search={place} index={index} show={showSet[index]} onHide={() => setShowSet([false, false, false, false])} />
                                </Card.Body>
                            </Card>
                        </Col>
                    )
                })}
            </Row>
            { console.log(showSet)}
            {/* show가 전부 true로 바뀌어서 전부 다 보이게 되는 것이다. */}
            <Row className="mt-2 d-flex justify-content-center">
                <Paginations index={index} endPage={endPage} handlePage={handlePage}></Paginations>
            </Row>
        </Container>

    );
}

export default Search
