import Review from '../models/Review.js'
import cheerio, { html } from "cheerio";
import jschardet from 'jschardet'
import iconv from 'iconv'
import fs from 'fs'
import axios from 'axios';
import { nextTick } from 'process';
const Iconv = iconv.Iconv

const search = async (req, res, next) => {
    try {
        let reviews = []
        let content = []
        const url = "https://www.google.com/search?q=" + encodeURI(req.params.search) + "+site%3Atistory.com&page_no=1"
        const response1 = await axios.get(url)
        // console.log(response1.data)
        const $1 = cheerio.load(response1.data);
        $1('.kCrYT').each(async function (i) {
            const title = $1(this).find('h3').text()
            const searchParams = new URLSearchParams($1(this).find('a').attr('href'));
            const link = searchParams.get("/url?q")
            const summary = $1(this).find('.s3v9rd').find('.s3v9rd').text()
            content.push(getReview(link))
            if (title) {
                reviews[i] = { title: title, link: link }
            } else if (summary) {
                reviews[i - 1] = { ...reviews[i - 1], summary: summary }
                reviews = reviews.filter(e => e)
            }
        })
        let promiseReview = await Promise.all(content)
        promiseReview = promiseReview.filter(e => typeof (e) === 'string')
        reviews.forEach(async (review, i) => {
            review["content"] = promiseReview[i]
        })
        res.send(reviews)
    } catch (error) {
        console.log(error)
        res.send(error)
    }
}

const getReview = async (link) => {
    if (link) {
        let content = '없음'
        const res = await axios.get(link)
        const $2 = cheerio.load(res.data);
        if ($2('.tt_article_useless_p_margin').text()) {
            content = $2('.tt_article_useless_p_margin').text()
        }
        return content
        console.log(content, link)
    }
}

export default { search, getReview }