import Place from '../models/Place.js'
import cheerio from 'cheerio'

const signup = async (req, res) => {
    const { name, email, password } = req.body
    console.log(name, email, password)
    try {
        if (!isLength(name, { min: 3, max: 10 })) {
            return res.status(422).send('Name must be 3-10 characters')
        }
        const newUser = await new User({
            name,
            email,
            password
        }).save()
        console.log(newUser)
        res.json(newUser)
    } catch (error) {
        console.log(error)
        res.status(500).send('User signup error')
    }
}

const search = async (req, res) => {
    // 정보들 크롤링 해오고 아래에 넣어주기

    const url = "https://section.blog.naver.com/Search/Post.nhn?keyword=" + keyword
    request(url, function (err, res, html) {   // URL로부터 가져온 페이지 소스가 html이란 변수에 담긴다.
        if (!err) {
            var $ = cheerio.load(html);

            // 블로그 title 정보 가져오기
            $(".entry-title > a").each(function () {
                var post = { "name": "", "address": "", "img": "" };
                var data = $(this);

                post["title"] = data.text();
                post["link"] = data.attr("href");
            });
        }
    })

    // try {
    //     const newPlace = await new Place({
    //         name: req.params.search,
    //         address,
    //         img,

    //     })
    // }
}

export default { signup, search }
