import React, { useState } from 'react';
import { Redirect } from 'react-router-dom';
import ohuh from '../ohuh.PNG'
import { Container, Row, Form, Image, InputGroup, Button, Col, Nav } from 'react-bootstrap';
import { handleLogout, isAuthenticated } from '../utils/auth.js'

function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");
  const user = isAuthenticated()

  if (state !== false) {
    return <Redirect to={`/search?keyword=${search}`} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  } //바뀌는 것이 있을때 이벤트 발생

  const handleSubmit = () => {
    setState(true);
  } //submit 버튼을 누르면 state 값을 true로 바뀐다

  return (
    <Container className="vh-100 d-flex justify-content-md-center align-items-center">
      <Col md={6} style={{ marginTop: 140 }}>
        <Nav className="justify-content-end" bg="#fff" variant="light" >
          {user ? <Nav.Link onClick={() => handleLogout()}>로그아웃</Nav.Link>
            : (
              <>
                <Nav.Link href="/signup">회원가입</Nav.Link>
                <Nav.Link href="/login">로그인</Nav.Link>
              </>
            )}
          <Nav.Link href='/bookmark'>북마크</Nav.Link>
        </Nav>
        <Row style={{ marginBottom: 20 }}>
          <Image src={ohuh} />
        </Row>
        <Row style={{ marginBottom: 500 }}>
          <Form className="vw-100" onSubmit={handleSubmit}>
            <InputGroup style={{ width: 560 }}>
              <Form.Control
                size="lg"
                placeholder="검색어를 입력하세요."
                aria-label="Large"
                aria-describedby="inputGroup-sizing-sm"
                onChange={handleChange}
              />
              <InputGroup.Append>
                <Button type='submit' variant="outline-secondary">검색</Button>
              </InputGroup.Append>
            </InputGroup>
          </Form>
        </Row>
      </Col>
    </Container>
  );
}

export default App;
