import express from 'express'
import connectDb from './utils/connectDb.js'
import placeRouter from './routes/place.routes.js'
import reviewRouter from './routes/review.routes.js'

connectDb()

const app = express()

app.use('/images', express.static('uploads/'))

app.use(express.json())

app.use(placeRouter)
app.use(reviewRouter)

app.get('/', (req, res) => {
    console.log("/ req.body", req.body)
    res.json({ message: "http://localhost3001/ 에 연결됨" })
})

app.listen(3001, () => {
    console.log('Listening on port 3001')
})