import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Modal, Container, Row, Col, Button, Badge, Card, Accordion, Carousel } from 'react-bootstrap';

function Place(props) {
  const [reviews, setReviews] = useState([])
  const getReview = () => {
    axios.get(`/api/review/${props.search.name}`)
      .then(res => {
        setReviews(res.data)
      })
      .catch(err => {
        console.log(err)
      })
  }

  useEffect(() => {
    getReview();
  }, [])


  return (
    <Modal {...props}
      size="xl"
      keyboard="true"
      variant="backdrop.in"
      // show={lgShow}
      // onHide={() => setLgShow(false)}
      aria-labelledby="example-modal-sizes-title-lg">
      <Modal.Header closeButton>
        <Modal.Title id="contained-modal-title-vcenter" style={{ fontSize: '40px' }}>
          {props.index + 1}. {props.search.name}
        </Modal.Title>
      </Modal.Header>
      <Modal.Body className="show-grid">
        <Container style={{ fontSize: '40px' }}>
          {reviews.map((review, index) => {
            return (
              <Row className="mt-4">
                <a href={review.link}>{review.title}</a>
                <div>{review.summary}</div>
              </Row>
            )
          })}
          </Container>

          {/* <Accordion defaultActiveKey="0">
            <Accordion.Toggle as={Button} variant="link" eventKey="0">
              <a className="mb-2">다음의 블로그 보기</a>
            </Accordion.Toggle>
            <Accordion.Collapse eventKey="0">
              <Card.Body><div>주도 전역을 지배하는 한라산은 남한에서 가장 높은 산으로 높이는 1,947.3m이다. 한라산이라는 이름은 산이 높아 산정에 서면 은하수를 잡아당길 수 있다는 뜻이며, 부악·원산·선산·두무악·영주산·부라산·혈망봉·여장군 등으로도 불려왔다.</div></Card.Body>
            </Accordion.Collapse>
            <Row>
              <Accordion.Toggle as={Button} variant="link" eventKey="1">
                <a className="mb-2">네이버의 블로그 보기</a>
              </Accordion.Toggle>
              <Accordion.Collapse eventKey="1">
                <Card.Body><div>한라산은 1966년 한라산 천연보호구역으로, 1970년 국립공원으로 지정되었다. 그리고 2002년에는 유네스코 생물권보전지역으로 지정되었으며 2007년에는 유네스코 세계자연유산으로 등재되었다. 2008년에는 물장오리오름 산정화구호 습지가 람사르 습지로 등록되어 보호 관리되고 있다</div></Card.Body>
              </Accordion.Collapse>
            </Row>
            <Row>
              <Accordion.Toggle as={Button} variant="link" eventKey="2">
                <a className="mb-2">구글의 블로그 보기</a>
              </Accordion.Toggle>
              <Accordion.Collapse eventKey="2">
                <Card.Body><div>한라산은 제주도에 있는 해발 1,947.06m, 면적 약 1,820km²의 화산으로, 제주도의 면적 대부분을 차지하고 있다. 정상에 백록담이라는 화산호가 있는데, 백록담이라는 이름은 흰 사슴이 물을 먹는 곳이라는 뜻에서 왔다고 전해진다.</div></Card.Body>
              </Accordion.Collapse>
            </Row>
          </Accordion>
          <Row style={{ color: 'white' }}>
            <a href="https://www.daum.net/" className="mb-2">다음</a><a href="https://www.naver.com/" className="mb-2">네이버</a><a href="https://www.google.com/" className="mb-2">구글</a>
          </Row>
        // </Container>
        <Carousel>
          <Carousel.Item interval={1000}>
            <h3>다음 블로그</h3>
            <div>주도 전역을 지배하는 한라산은 남한에서 가장 높은 산으로 높이는 1,947.3m이다. 한라산이라는 이름은 산이 높아 산정에 서면 은하수를 잡아당길 수 있다는 뜻이며, 부악·원산·선산·두무악·영주산·부라산·혈망봉·여장군 등으로도 불려왔다.</div>
          </Carousel.Item>
          <Carousel.Item interval={1000}>
            <h3>네이버 블로그</h3>
            <div>한라산은 1966년 한라산 천연보호구역으로, 1970년 국립공원으로 지정되었다. 그리고 2002년에는 유네스코 생물권보전지역으로 지정되었으며 2007년에는 유네스코 세계자연유산으로 등재되었다. 2008년에는 물장오리오름 산정화구호 습지가 람사르 습지로 등록되어 보호 관리되고 있다</div>
          </Carousel.Item>
          <Carousel.Item interval={1000}>
            <h3>구글 블로그</h3>
            <div>한라산은 제주도에 있는 해발 1,947.06m, 면적 약 1,820km²의 화산으로, 제주도의 면적 대부분을 차지하고 있다. 정상에 백록담이라는 화산호가 있는데, 백록담이라는 이름은 흰 사슴이 물을 먹는 곳이라는 뜻에서 왔다고 전해진다.</div>
          </Carousel.Item>
        </Carousel> */}
      </Modal.Body>
      <Modal.Footer>
        <Button block onClick={props.onHide}>Close</Button>
      </Modal.Footer>
    </Modal>
  );
}

export default Place;
