/*global kakao*/
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Container, Row, Image } from 'react-bootstrap';
import queryString from 'query-string'
import { Link } from 'react-router-dom';
import ohuh from '../ohuh-sm.PNG';

function Place(props) {
  console.log(props)
  const [db, setDb] = useState(false)
  const [index, setIndex] = useState(0)
  const [reviews, setReviews] = useState([])
  const place = queryString.parse(props.location.search).place

  const getReview = (index) => {
    console.log(index, "dlseprtm")
    axios({ url: `/api/review?keyword=${place}&index=${index}`, method: 'post', data: { db: db } })
      .then(res => {
        console.log("place res.data", res.data)
        setReviews([...reviews, ...res.data.review])
        setDb(res.data.db)
        setIndex(res.data.index)
      })
      .then(() => {
        console.log(index, "인텍스", db)
      })
      .catch(err => {
        console.log(err)
      })
  }

  useEffect(() => {
    // const script = document.createElement("script");
    // script.async = true;
    // script.src =
    //   "https://dapi.kakao.com/v2/maps/sdk.js?appkey=908d6cabedae3bbac126305e53137d0d&autoload=false";
    // document.head.appendChild(script);

    // script.onload = () => {
    //   kakao.maps.load(() => {
    //     let container = document.getElementById("Mymap");
    //     let options = {
    //       center: new kakao.maps.LatLng(37.506502, 127.053617),
    //       level: 7
    //     };

    //     const map = new window.kakao.maps.Map(container, options);

    //   });
    // }
    getReview();
    window.addEventListener("scroll", infiniteScroll);
    return () => { window.removeEventListener("scroll", infiniteScroll); }
  }, []);

  // useEffect(() => {
  //   getReview();

  // }, [index])

  const infiniteScroll = () => {
    const { documentElement, body } = document;
    const scrollHeight = Math.max(documentElement.scrollHeight, body.scrollHeight);
    const scrollTop = Math.max(documentElement.scrollTop, body.scrollTop);
    const clientHeight = documentElement.clientHeight;
    if (scrollTop + clientHeight >= scrollHeight) {
      // setIndex(index + 1)
      getReview(index + 1);
      console.log("더불러", index + 1)
    }
    console.log(scrollHeight, scrollTop, clientHeight)
  }

  return (
    <Container>
      <Link to="/" className="d-flex justify-content-center"><Image src={ohuh} /></Link>
      <div class="d-flex align-items-center p-3 my-3 text-white bg-info rounded shadow-sm">
        <div >
          <h1 class="h6 mb-0 text-white">{place}</h1>
        </div>
      </div>

      <div class="my-3 p-3 bg-white rounded shadow-sm">
        <h6 class="border-bottom pb-2 mb-0">관광지 정보</h6>
        {/* <MapContents id="Mymap"></MapContents> */}
        {/* <div class="d-flex text-muted pt-3">
          
          <p class="pb-3 mb-0 small lh-sm border-bottom">
            <strong class="d-block text-gray-dark">@username</strong>
        Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.
      </p>
        </div>
        <div class="d-flex text-muted pt-3">
          <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="#e83e8c" /><text x="50%" y="50%" fill="#e83e8c" dy=".3em">32x32</text></svg>

          <p class="pb-3 mb-0 small lh-sm border-bottom">
            <strong class="d-block text-gray-dark">@username</strong>
        Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.
      </p>
        </div>
        <div class="d-flex text-muted pt-3">
          <svg class="bd-placeholder-img flex-shrink-0 me-2 rounded" width="32" height="32" xmlns="http://www.w3.org/2000/svg" role="img" aria-label="Placeholder: 32x32" preserveAspectRatio="xMidYMid slice" focusable="false"><title>Placeholder</title><rect width="100%" height="100%" fill="#6f42c1" /><text x="50%" y="50%" fill="#6f42c1" dy=".3em">32x32</text></svg>

          <p class="pb-3 mb-0 small lh-sm border-bottom">
            <strong class="d-block text-gray-dark">@username</strong>
        Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.
      </p>
        </div> */}
        <small class="d-block text-end mt-3">
          <a href={`https://www.google.com/search?q=${place}&tbm=isch`}>사진 더보러가기</a>
        </small>
      </div>

      <div class="my-3 p-3 bg-white rounded shadow-sm">
        <h6 class="border-bottom pb-2 mb-0">관광지 후기</h6>
        {Array.isArray(reviews) ? reviews.map((review, index) => {
          return (
            <div class="d-flex text-muted pt-3">
              <div class="pb-3 mb-0 small lh-sm border-bottom w-100">
                <div class="d-flex justify-content-between">
                  <strong class="text-gray-dark">{review.title}</strong>
                  <a href={review.link}>블로그로 이동</a>
                </div>
                <span class="d-block">{review.summary}</span>
              </div>
            </div>
          )
        })
          : "리뷰가 없습니다."}


        <small class="d-block text-end mt-3">
          <a href="#">리뷰 더보기</a>
        </small>
      </div>
    </Container>

    // <Container {...props}>
    //   {place}
    //   {Array.isArray(reviews) ? reviews.map((review, index) => {
    //     return (
    //       <Row className="mt-4">
    //         <a href={review.link}>{review.title}</a>
    //         <div>{review.summary}</div>
    //         <div>{review.content}</div>
    //       </Row>
    //     )
    //   })
    //     : "리뷰가 없습니다."}
    // </Container>
  );
}

export default Place;
