import React, { useState, useEffect } from 'react'
import { Alert, Col, Card, Container, Form, Row, Button, Nav, Navbar, ListGroup, Image, Table } from "react-bootstrap"
import axios from "axios"
import catchErrors from './utils/catchErrors.js'
import { isAuthenticated } from './utils/auth'
import { Redirect } from 'react-router-dom'

const INIT_PAGE = {
    name: '',
    bookmark: []
}

const user = isAuthenticated()

function Bookmark() {
    const [page, setPage] = useState(INIT_PAGE)
    const [error, setError] = useState('')

    async function handleSubmit(event) {
        event.preventDefault()
        try {
            setError('')
            const response = await axios.post('/api/users/bookmark',page)
            console.log(page)
            // setUser(INIT_USER)
        } catch (error) {
            console.log(error)
            catchErrors(error, setError)
        }   
    }

    useEffect(() => {
        Bookmark(user)
    }, [user])



    return (
        <Container>
            <Navbar bg="primary" variant="dark">
                <Navbar.Brand href="/">북마크</Navbar.Brand>
                <Nav className="mr-auto">
                    <Nav.Link href="/">Home</Nav.Link>
                </Nav>
            </Navbar>
                <Form>
                    <ListGroup>
                        <ListGroup.Item action href="">북마크1</ListGroup.Item>
                        <ListGroup.Item>북마크2</ListGroup.Item>
                    </ListGroup>
                </Form>
        </Container>
    )
}

export default Bookmark