/*global kakao*/
import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Container, Row, Image, Col } from 'react-bootstrap';
import queryString from 'query-string'
import { Link } from 'react-router-dom';
import ohuh from '../ohuh-sm.PNG';
import catchErrors from '../utils/catchErrors';

function Place(props) {
  const [error, setError] = useState('')
  const [review, setReviews] = useState({ reviews: [], db: false, index: 0 })
  const { name, src, address } = queryString.parse(props.location.search)
  console.log(review)

  const getReview = async () => {
    try {
      setError('')
      const res = await axios({ url: `/api/review?keyword=${name}&index=${review.index}`, method: 'post', data: { db: review.db } })
      console.log("place res.data", res.data)
      setReviews({ reviews: [...review.reviews, ...res.data.review], db: res.data.db, index: res.data.index })
    } catch (error) {
      catchErrors(error, setError)
    }
  }


  useEffect(() => {
    getReview();
  }, []);


  return (
    <Container>

      <Link to="/"><Image style={{ margin: "1%" }} src={ohuh} /></Link>
      <div className="d-flex align-items-center p-3 my-3 text-white bg-info rounded shadow-sm">
          <h1 className="h6 mb-0 text-white">{name}</h1>
      </div>

      <div className="my-3 p-3 bg-white rounded shadow-sm">
        <h6 className="border-bottom pb-2 mb-0">관광지 정보</h6>
        <Row>
          <Col>
            <Image variant="top" style={{ padding: "5%", width: "100%", height: "100%" }} src={src} />
          </Col>
          <Col>
            <div className="d-flex text-muted pt-3">
              <p className="pb-3 mb-0 lh-sm border-bottom">
                <strong className="d-block text-gray-dark">관광지 이름</strong>
                {name}
              </p>
            </div>
            <div className="d-flex text-muted pt-3">

              <p className="pb-3 mb-0 lh-sm border-bottom">
                <strong className="d-block text-gray-dark">관광지 주소</strong>
                {address}
              </p>
            </div>
          </Col>
        </Row>

        <small className="d-block text-end mt-3">
          <a href={`https://www.google.com/search?q=${name}&tbm=isch`}>사진 더보러가기</a>
        </small>
      </div>

      <div className="my-3 p-3 bg-white rounded shadow-sm">
        <h6 className="border-bottom pb-2 mb-0">관광지 후기</h6>
        {Array.isArray(review.reviews) ? review.reviews.map((review) => {
          return (
            <div className="d-flex text-muted pt-3">
              <div className="pb-3 mb-0 small lh-sm border-bottom w-100">
                <div className="d-flex justify-content-between">
                  <strong className="text-gray-dark">{review.title}</strong>
                  <a href={review.link}>블로그로 이동</a>
                </div>
                <span className="d-block">{review.summary}</span>
              </div>
            </div>
          )
        })
          : "리뷰가 없습니다."}



        <small className="d-block text-end mt-3">
          <a href="#" onClick={getReview} >리뷰 더보기</a>
        </small>
      </div>
    </Container>
  );
}

export default Place;
