import React, { useState, useEffect } from 'react';
import { Redirect } from 'react-router-dom';
import ohuh from '../ohuh.PNG';
import { Container, Row, Form, Image, InputGroup, Button, Col, Card } from 'react-bootstrap';
import axios from 'axios';
import Place from '../Components/Place';

function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");
  const [show, setShow] = useState(false);
  const [recommend, setRecommend] = useState([{ name: " ", address: " ", img: " " }]);
  const [latest, setLatest] = useState([{ name: " ", address: " ", img: " " }]);


  useEffect(() => {
    getRecommend()
    getLatest()
  }, []);

  if (state !== false) {
    return <Redirect to={`/search?keyword=${search}`} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  } //바뀌는 것이 있을때 이벤트 발생

  const handleSubmit = () => {
    setState(true);
  } //submit 버튼을 누르면 state 값을 true로 바뀐다

  const getRecommend = () => {
    axios.get(`/api/app/recommend`)
      .then(res => {
        setRecommend(res.data)
      })
      .catch(err => {
        console.log("APP RECOMMEND ERROR", err)
      })
  }

  const getLatest = () => {
    axios.get(`/api/app/lastest`)
      .then(res => {
        setLatest(res.data)
      })
      .catch(err => {
        console.log("APP LATEST ERROR", err)
      })
  }



  return (

    <Container className="vh-100 ">
      <Col md={12} >
        <Row className="justify-content-center" >
          <Image src={ohuh} style={{ margin: "5%", marginTop : "3%" }} />
        </Row>
        <Row style={{ marginBottom: "5%" }}>
          <Form className="vw-100" onSubmit={handleSubmit}>
            <InputGroup >
              <Form.Control
                size="lg"
                placeholder="검색어를 입력하세요."
                aria-label="Large"
                aria-describedby="inputGroup-sizing-sm"
                onChange={handleChange}
              />
              <InputGroup.Append>
                <Button type='submit' variant="outline-secondary">검색</Button>
              </InputGroup.Append>
            </InputGroup>
          </Form>
        </Row>
        <Row  >
          <Col md={6} >
            <h1 className=" d-flex justify-content-center" style={{marginBottom:"7%"}}>인기관광지</h1>
            <Card align="center" border="info" style={{ margin: "3%" }}>
              <Card.Title style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }} >{recommend.name}</Card.Title>
              <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={recommend.img} />
              <Card.Body >
                <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                  {recommend.address} </Card.Text>
                <Button variant="primary" onClick={() => {
                  setShow(true)
                }}>{recommend.name} 자세히 살펴보기</Button>
                <Place place={recommend} show={show} onHide={() => setShow(false)} />
              </Card.Body>
            </Card>
          </Col>

          <Col md={6} >
            <h1 className=" d-flex justify-content-center" style={{marginBottom:"7%"}}>최근 검색관광지</h1>
            <Card align="center" border="info" style={{ margin: "3%" }}>
              <Card.Title style={{ margin: "3%", fontSize: '200%', fontWeight: 'bold' }} >{latest.name}</Card.Title>
              <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={latest.img} />
              <Card.Body >
                <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                  {latest.address} </Card.Text>
                <Button variant="primary" onClick={() => {
                  setShow(true)
                }}>{latest.name} 자세히 살펴보기</Button>
                <Place place={latest} show={show} onHide={() => setShow(false)} />
              </Card.Body>
            </Card>
          </Col>
        </Row>
      </Col>
    </Container>


  );
}

export default App;
