import React, { useState, useEffect } from 'react'
import { Alert, Col, Card, Container, Form, Row, Button, Nav, Navbar, ListGroup, Image, Table } from "react-bootstrap"
import axios from "axios"
import catchErrors from './utils/catchErrors.js'
import { isAuthenticated } from './utils/auth'


const INIT_PAGE = {
    bookmark: ['성산일출봉', '제주도', '한라산', '주상절리', '오설록 티 뮤지엄',]

}

const user = isAuthenticated()

function Bookmark() {
    const [page, setPage] = useState(INIT_PAGE)
    const [error, setError] = useState('')
    const [success, setSuccess] = useState(false)
    const [state, setState] = useState(false);

    const user = isAuthenticated()

    const userId = localStorage.getItem('loginStatus')

    async function getBookmark() {
        try {
            setError('')
            console.log(page.bookmark)
            const bookmark = page.bookmark
            console.log(userId)
            const response = await axios.put(`/api/users/bookmark`, { bookmark: bookmark, userId: userId })
            console.log(response.data)
        } catch (error) {
            catchErrors(error, setError)
        }
    }

    // async function handleSubmit(e){
    //     setState(true);  //버튼이 눌려서 handlesubmit이될때 setState값이 true로 바뀐다
    //     try { //respons 서버에 post로 요청하여 데이터를 받아온다
    //         const response = await axios.post('/api/users/bookmark', page)
    //         setSuccess(true)
    //     } catch (error) {
    //         console.log(error)
    //         catchErrors(error, setError)
    //     }
    // }

    // useEffect(() => {
    //     getBookmark(user)
    // }, [user])



    return (
        <Container>
            <Navbar bg="primary" variant="dark">
                <Navbar.Brand href="/">북마크</Navbar.Brand>
                <Nav className="mr-auto">
                    <Nav.Link href="/">Home</Nav.Link>
                </Nav>
                <Button type='submit' onClick={getBookmark}>저장</Button>
            </Navbar>
            <Form>
                <ListGroup>
                    <ListGroup.Item>{page.bookmark[0]}</ListGroup.Item>
                    <ListGroup.Item>{page.bookmark[1]}</ListGroup.Item>
                    <ListGroup.Item>{page.bookmark[2]}</ListGroup.Item>
                    <ListGroup.Item>{page.bookmark[3]}</ListGroup.Item>
                    <ListGroup.Item>{page.bookmark[4]}</ListGroup.Item>
                </ListGroup>
            </Form>
        </Container>
    )
}

export default Bookmark