import Places from '../models/Place.js'

const searchRecommend = async (req, res, next,) => {
    let responseRecommend = await Places.aggregate([
        {
            
            $project: {
                name:1,
                address:1,
                img:1,
                timeslength: { $cond: { if: { $isArray: "$times" }, then: { $size: "$times" }, else: 'NA' } }
            }
        }
    ])


    let result = responseRecommend.sort((a, b) => {
        return b.timeslength-a.timeslength
    });
    res.send(result[0])
}

const searchLatest = async (req, res, next) => {

    let responseLatest = await Places.find({}).sort({ updatedAt: -1 })
    res.send(responseLatest[0])


}

export default { searchRecommend, searchLatest }
