import * as React from 'react';
import { StyleSheet, View, Text, TextInput, Button } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import PostMoney from './PostMoney';
import MainScreen from './MainScreen';

const Tab = createBottomTabNavigator();

function App() {
  return (
    <NavigationContainer>
      <Tab.Navigator screenOptions={({ route }) => ({
          tabBarIcon: ({ focused, color, size }) => {
            let iconName;

            if (route.name === 'Main') {
              iconName = focused
                ? 'home'
                : 'home-outline';
            } else if (route.name === 'Monthly') {
              iconName = focused ? 'calendar' : 'calendar-outline';
            } else if (route.name === 'Analy') {
              iconName = focused ? 'bar-chart':'bar-chart-outline';
            }

            // You can return any component that you like here!
            return <Ionicons name={iconName} size={size} color={color} />;
          },
        })}
        tabBarOptions={{
          activeTintColor: 'tomato',
          inactiveTintColor: 'gray',
        }}>
        <Tab.Screen name="Main" component={MainScreen} />
        <Tab.Screen name="Monthly" component={Monthly} />
        <Tab.Screen name="Analy" component={PostMoney} />
      </Tab.Navigator>
    </NavigationContainer>
  );
}

export default App;
