import React, { useState, useEffect } from 'react';
import Calendar from './components/Calendar';
import calApi from './db/calendarInfo.api';
import { useIsFocused } from '@react-navigation/native';

const Montly = ({ navigation }) => {
  const isFocused = useIsFocused();

  const date = new Date();
  const [year, setYear] = useState(date.getFullYear());
  const [month, setMonth] = useState(date.getMonth());
  const todayM = date.getMonth();
  const todayY = date.getFullYear();
  const [totalM, setTotalM] = useState([]);

  const getData = async () => {
    try {
      const resDBdata = await calApi.getFullData({ year: year, month: month })
      setTotalM(resDBdata)
    } catch (error) {
      console.log('error in getData', error)
    }
  }
  useEffect(() => {
    getData()
  }, [month])

  useEffect(() => {
    getData()
    setMonth(todayM)
    setYear(todayY)
  }, [isFocused])

  return (
    <Calendar navigation={navigation} MData={totalM} year={year} setYear={setYear} month={month} setMonth={setMonth} todayM={todayM} todayY={todayY} />
  )
}

export default Montly;