import React from 'react';
import { ButtonGroup } from 'react-native-elements';
import { StyleSheet, Text } from 'react-native';

const ButtonsForm = (props) => {
    const components = [];

    for (let i = 0; i < props.group.length ; i++) {
        components[i] = { element: () => <Text>{props.group[i]}</Text> }
    }

    return (
        <ButtonGroup
            onPress={props.onPress}
            selectedIndex={props.selectedIndex}
            buttons={components}
            containerStyle={style.container}
            selectedButtonStyle={style.selectedButton}
            selectedTextStyle={style.selectedText}
        />
    );
};

const style = StyleSheet.create({
    container: {
        height: 50,
        flexDirection: 'row',
        alignItems: "center",
        backgroundColor: "#f5f5f5",
    },
    text: {
        color: "#808080",
        fontSize: 24
    },
    selectedButton: {
        backgroundColor: "#adadad",
    },
    selectedText: {
        color: "#1467ff",
        fontWeight: "bold",
    },
})

export default ButtonsForm
