import React from 'react';
import { View, Text, StyleSheet, Dimensions } from 'react-native';
import { BarChart } from "react-native-chart-kit";
import { Button } from 'react-native-elements';
import Ionicons from 'react-native-vector-icons/Ionicons';

const screenWidth = Dimensions.get("window").width;
const screenHeight = Dimensions.get("window").height;

const ChartY = ({ resDataY, year, setYear }) => {
  const chartConfig = {
    backgroundGradientFrom: "#ffffff", //좌측 색
    backgroundGradientFromOpacity: 1,
    backgroundGradientTo: "#ffffff", // 우측 색
    backgroundGradientToOpacity: 1,
    color: (opacity = 1) => `rgba(48, 48, 48, ${opacity})`,
    strokeWidth: 2, // optional, default 3
    barPercentage: 0.5, // 그래프 width
    useShadowColorFromDataset: false,// optional, default is false
    fillShadowGradientOpacity: 1, // 좀 더 진하게만 할 뿐 단색 설정은 못하는 것 같음

  };
  const prevBtn = () => {
    setYear(year - 1)
  };
  const nextBtn = () => {
    setYear(year + 1)
  }

  console.log('잠만확인', resDataY.temp1[0].datasets[0].data, '|', resDataY.temp2[0].datasets[0].data)
  let totalYI = (resDataY.temp1[0].datasets[0].data).reduce((acc, curr) => acc + curr, 0);
  let totalYO = (resDataY.temp2[0].datasets[0].data).reduce((acc, curr) => acc + curr, 0);
  console.log('합산 확인', totalYI, '|', totalYO)
  return (
    <>
      <View style={{ flexDirection: 'row' }}>
        <Button icon={
          <Ionicons name='chevron-back-sharp' onPress={prevBtn} size={15} color='black' />
        } type='clear' />
        <Text>{year}년</Text>
        <Button icon={
          <Ionicons name='chevron-forward-sharp' onPress={nextBtn} size={15} color='black' />
        } type='clear' />
      </View>
      <View>
        <Text style={style.Font}>수입:  {totalYI}원</Text>
        <BarChart
          style={{ marginBottom: "2%", marginTop: "2%" }}
          data={resDataY.temp1[0]}
          width={screenWidth}
          height={screenHeight / 3}
          chartConfig={{ ...chartConfig, fillShadowGradient: '#1E90FF' }}
          fromZero={true}
        />
        <Text style={style.Font}>지출:  {totalYO}원 </Text>
        <BarChart
          style={{ marginTop: "2%" }}
          data={resDataY.temp2[0]}
          width={screenWidth}
          height={screenHeight / 3}
          chartConfig={{ ...chartConfig, fillShadowGradient: '#DC143C' }}
          fromZero={true}
        />
      </View>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    textAlign: "center",
    fontSize: 20,
    fontFamily: 'Jua-Regular'
  },
});

export default ChartY;