import React, { useState } from 'react';
import { StyleSheet, Button, View, Text, TextInput, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';
import DatePicker from '../components/DatePicker.js';
import InputBox from '../components/InputBox';

const ReviewSchema = yup.object({
    date: yup.string() //string만 받는다
        .required(),  //아무것도 입력안했하면 안받음
    message: yup.string()
        .required()
        .min(2),
    money: yup.number()
        .required(),
    remained_money: yup.number()
        .required()
})

const getDate = () => {
    var date = new Date();
    return (String(date.toJSON()).split(/T/)[0])
}
// const [date, setDate] = useState(getDate())

function DeptForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: '', message: '', money: '', remained_money: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {//위의 4개의 val들을 전달

                        addInfo(values);
                    }}

                >

                    {({ handleChange, handleSubmit, values }) => (
                        <View>

                            <DatePicker
                                inputTitle='날짜'
                                date={values.date || getDate()}//오늘날짜 아니면 바뀐날짜
                                setDate={handleChange('date')}
                            />
                            <InputBox
                                inputTitle="내용"
                                onChangeText={handleChange('message')}
                                value={values.message}

                            />
                            <InputBox
                                inputTitle="금액"
                                onChangeText={handleChange('money')}
                                value={values.money}
                                keyboardType="numeric"

                            />
                            <InputBox
                                inputTitle="남은금액"
                                onChangeText={handleChange('remained_money')}
                                value={values.remained_money}
                                keyboardType="numeric"

                            />

                            <View style={{ marginVertical: '10%', marginHorizontal: 10 }}>
                                <Button title='입력' color = 'dodgerblue'  onPress={handleSubmit} />
                            </View>

                        </View>
                    )}

                </Formik>

            </View >
        </TouchableWithoutFeedback>
    )
}

export default DeptForm;