import React, { useState, useEffect } from 'react';
import { FlatList, View, Text, StyleSheet, Dimensions } from 'react-native';
import { Button } from 'react-native-elements';
import Ionicons from 'react-native-vector-icons/Ionicons';
import { PieChart } from "react-native-chart-kit";

const screenWidth = Dimensions.get("window").width;
const screenHeight = Dimensions.get("window").height;

const ChartItem = ({ item }) => {
  return (
    <>
      <View style={{
        flexDirection: "row", padding: "5%", borderColor: '#d3d3d3', //light grey
        borderWidth: 1, borderTopWidth: 0,
      }}>
        <Text style={[style.itemText, style.Font]}>{item.name}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{item.total}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{item.percentage}%</Text>
        <Text></Text>
      </View>
    </>
  );
};

const ChartM = ({
  resDataM,
  year,
  setYear,
  month,
  setMonth
}) => {
  const chartConfig = {
    backgroundGradientFrom: "#abbcd6", //좌측 색
    backgroundGradientFromOpacity: 0.5,
    backgroundGradientTo: "#E6DDC5", // 우측 색
    backgroundGradientToOpacity: 0.2,
    backgroundColor: "#ffffff", // 어디에 적용된건지 잘 모르겠음
    color: (opacity = 1) => `rgba(0, 93, 232, ${opacity})`, // data의 색상 계산할 때 사용하는 함수
    //color: (opacity = 1) => `rgba(255, 255, 255, ${opacity})`,
    strokeWidth: 2, // optional, default 3
    barPercentage: 0.5, // 그래프 width
    useShadowColorFromDataset: false,// optional, default is false
    //fillShadowGradient: 'blue',
    fillShadowGradientOpacity: 1, // 좀 더 진하게만 할 뿐 단색 설정은 못하는 것 같음

  };

  const renderChart = ({ item }) => {
    return (
      <ChartItem item={item} />
    )
  }
  const prevBtn = () => {
    if (month < 1) {
      setYear(year - 1)
      setMonth(11)
    } else {
      setMonth(month - 1)
    }
  };
  const nextBtn = () => {
    if (month > 10) {
      setYear(year + 1)
      setMonth(0)
    } else {
      setMonth(month + 1)
    }
  }

  console.log('sdfaslfsakflf', resDataM)
  return (
    <>
      <View style={{ flexDirection: 'row' }}>
        <Button icon={
          <Ionicons name='chevron-back-sharp' onPress={prevBtn} size={15} color='black' />
        } type='clear' />
        <Text>{year}.{month + 1}</Text>
        <Button icon={
          <Ionicons name='chevron-forward-sharp' onPress={nextBtn} size={15} color='black' />
        } type='clear' />
      </View>
      <View>
        {
          resDataM.length != 0 ?
            < PieChart
              data={resDataM}
              width={screenWidth}
              height={screenHeight / 3} //그래프의 높이가 커지기만
              chartConfig={chartConfig}
              accessor={"total"}
              backgroundColor={"#ffffff"}
              absolute
            /> : <Text style={style.infoText}> 지출 내역이 없습니다.</Text>
        }
        <FlatList
          style={{ backgroundColor: "#FFFFFF" }}
          data={resDataM}
          renderItem={renderChart}
          keyExtractor={item => item.color}
        />
      </View>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 20,
    fontFamily: 'GowunDodum-Regular'
  },
  itemTextNum: {
    flex: 1,
    textAlign: "center",
    fontFamily: 'GowunDodum-Regular'
  },
  itemText: {
    flex: 1,
    fontFamily: 'GowunDodum-Regular'
  },
  infoText: {
    fontSize: 30,
    textAlign: "center",
    marginTop: "20%",
    fontFamily: 'GowunDodum-Regular'
  }
});

export default ChartM;