import { DEBUG, enablePromise } from 'react-native-sqlite-storage';
import getDb from './moneyDB'

DEBUG(true);
enablePromise(true);

const insertMoney = async (moneyData) => {
    const db = await getDb();
    return new Promise((resolve, reject) => {
        db.transaction((tx) => {
            console.log("데이터 삽입하기");
            tx.executeSql('INSERT INTO Money (type, date, contents, price, asset_type, category, subcategory) VALUES (?,?,?,?,?,?,?);',
                moneyData,
                (error) => console.log(error))
            resolve('데이터 삽입 완료');
        })
    })
};

const selectCategories = async (type_id) => {
    const db = await getDb();
    return new Promise((resolve, reject) => {
        db.transaction(async (tx) => {
            console.log("카테고리 부르기");
            const [txn, results] = await tx.executeSql(`SELECT * FROM categories WHERE type_id=${type_id}`);
            console.log('item length', results.rows.length);
            const temp = [];
            for (let i = 0; i < results.rows.length; i++) {
                const tempId = results.rows.item(i).category_id;
                const tempName = results.rows.item(i).category_name;
                temp.push({ id: tempId, value: tempName });
            }
            console.log(temp)
            resolve(temp);
        })
    })
}

const selectSubCategories = async () => {
    const db = await getDb();
    return new Promise((resolve, reject) => {
        db.transaction(async (tx) => {
            console.log("서브 카테고리 부르기");
            const [txn, results] = await tx.executeSql('SELECT * FROM subcategories');
            console.log('item length', results.rows.length);
            const temp = [];
            for (let i = 0; i < results.rows.length; i++) {
                const tempId = results.rows.item(i).subcategory_id;
                const tempName = results.rows.item(i).subcategory_name;
                const tempCatId = results.rows.item(i).category_id;
                temp.push({ id: tempId, value: tempName, foreign_id: tempCatId });
            }
            console.log(temp)
            resolve(temp);
        })
    })
}

const selectAssetsType = async () => {
    const db = await getDb();
    return new Promise((resolve, reject) => {
        db.transaction(async (tx) => {
            console.log("자산 유형 부르기");
            const [txn, results] = await tx.executeSql('SELECT * FROM assets_type');
            console.log('item length', results.rows.length);
            const temp = [];
            for (let i = 0; i < results.rows.length; i++) {
                const tempId = results.rows.item(i).assets_id;
                const tempName = results.rows.item(i).assets_name;
                temp.push({ id: tempId, value: tempName });
            }
            console.log(temp)
            resolve(temp);
        })
    })
}


const moneyApi = {
    insertMoney,
    selectCategories,
    selectSubCategories,
    selectAssetsType,
}

export default moneyApi;