import React from 'react';
import { StyleSheet, Text, TouchableOpacity, View } from 'react-native';
import Ionicons from 'react-native-vector-icons/Ionicons';



function TodoItem({ item, pressHandler }) {
    return (
        <View style={styles.item}>
            <Ionicons name='trash-outline' size={15} color='#333' onPress={() => pressHandler(item.key)} />
            <Text style={styles.itemText}>{item.date}</Text>
            <Text style={styles.itemText}>{item.person}</Text>
            <Text style={styles.itemText}>{item.money}</Text>
            <Text style={styles.itemText}>{item.remained_money}</Text>
        </View>

    )

}

const styles = StyleSheet.create({
    item: {
        padding: 16,
        marginTop: 16,
        borderColor: '#bbb', //light grey
        borderWidth: 1,
        borderStyle: 'd',
        borderStyle: 'dashed', //little line
        borderRadius: 10,
        flexDirection: 'row' //같은 행에 있도록
    },
    itemText: {
        marginLeft: 10,
    }
})

export default TodoItem;