import React, { useState } from 'react';
import { StyleSheet, Text, View, FlatList, TouchableOpacity, Modal, TouchableWithoutFeedback, Keyboard } from 'react-native';
import TodoItem from './components/TodoItem';
import Ionicons from 'react-native-vector-icons/Ionicons';
import { NavigationContainer } from '@react-navigation/native';
import MemoDetails from './screens/MemoDetails';
import MemoForm from './screens/MemoForm';
import ButtonsForm from './components/ButtonsForm';
import { TabView } from 'react-native-elements';



function MemoPage({ navigation }) {
    const [selectedIndex, setSelectedIndex] = useState(0)
    const [modalOpen, setModalOpen] = useState(false);
    const [todo, setTodo] = useState([
        { date: '매달10일', person: '식비', money: '100만원', key: '1' },
        { date: '매달20일', person: '휴대폰요금', money: '100만원', key: '2' },
        { date: '매달24일', person: '생활비', money: '100만원', key: '3' }
    ]);

    const addInfo = (info) => {
        info.key = Math.random().toString(); //앞에 key를 받아올수있도록 생성
        setTodo((currentInfos) => {
            return [info, ...currentInfos]; //새로운 정보와 지금까지 정보를 합친다
        });
        setModalOpen(false); //modal이 보여지지 않게
    }

    const pressHandler = (key) => {
        setTodo((prevTodos) => {
            return prevTodos.filter(todo => todo.key != key);
        });
    }
    const [todos, setTodos] = useState([
        { date: '매달10일', person: '농협', money: '100만원', key: '1' },
        { date: '매달20일', person: '삼성전자', money: '100만원', key: '2' },
        { date: '매달30일', person: '비트코인', money: '100만원', key: '3' }
    ]);



    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View Style={style.container}>
                <ButtonsForm
                    onPress={(index) => setSelectedIndex(index)}
                    selectedIndex={selectedIndex}
                    group={["적금", "생활비"]} />

                <View>
                    <View style={{ width: '100%', height: '75%' }}>
                        <TabView value={selectedIndex} onChange={setSelectedIndex} >
                            <TabView.Item style={{ width: '100%', height: '100%' }}>
                                <FlatList
                                    data={todos}
                                    renderItem={({ item }) => (
                                        <TouchableOpacity onPress={() => navigation.navigate('MemoDetails', item)}>
                                            <TodoItem item={item} pressHandler={pressHandler} />
                                        </TouchableOpacity>
                                    )}
                                />
                            </TabView.Item>
                            <TabView.Item style={{ width: '100%', height: '100%' }}>
                                <FlatList
                                    data={todo}
                                    renderItem={({ item }) => (
                                        <TouchableOpacity onPress={() => navigation.navigate('MemoDetails', item)}>
                                            <TodoItem item={item} pressHandler={pressHandler} />
                                        </TouchableOpacity>
                                    )}
                                />
                            </TabView.Item>
                        </TabView>
                    </View>
                    <Ionicons
                        name='add'
                        size={24}
                        style={style.modalToggle} //...은 중괄호를 풀어서 합치려고 이용함
                        onPress={() => setModalOpen(true)}
                    />
                </View>
                <View>
                    <Modal visible={modalOpen} animationType='slide'>
                        <View style={style.modalContent}>
                            <Ionicons
                                name='close'
                                size={24}
                                style={style.modalToggle}
                                onPress={() => setModalOpen(false)}
                            />
                            <MemoForm addInfo={addInfo} />

                        </View>
                    </Modal>
                </View>
            </View>
        </TouchableWithoutFeedback >
    );
}






const style = StyleSheet.create({
    container: {
        flex: 1,
        width: '100%',
    },
    modalToggle: {
        borderWidth: 1,
        borderColor: 'gray', //gray
        padding: 5,
        borderRadius: 10,
        alignSelf: 'center', //위치를 center로
    },

    modalContent: {
        flex: 1, //이후 유용한 키보드를 추가하려고 ex)dismissing keyboard
    },


    TextInput: {
        borderColor: 'skyblue',
        height: 40,
        margin: 12,
        borderWidth: 1
    },
    Font: {
        fontSize: 24
    }
});

export default MemoPage;
