import React from 'react';
import { StyleSheet, Pressable, Text } from 'react-native';

const StyledButton = (props) => {
    return (
        <Pressable
            style={({ pressed }) => [
                {
                    backgroundColor: pressed ? '#437dd9' : '#4e8ff5',
                },
                style.pressableStyle,
                props.style
            ]}
            onPress={props.onPress}>
            <Text style={style.buttonText}>{props.name}</Text>
        </Pressable>
    );
};

const style = StyleSheet.create({
    pressableStyle: {
        alignItems: "center",
        justifyContent: "center",
        marginRight: 3,
        borderRadius: 2,
    },
    buttonText: {
        fontFamily: 'GowunDodum-Regular',
        fontSize: 20,
    },
})

export default StyledButton
