import * as React from 'react';
import { StyleSheet, View, Text, TextInput, Button } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createStackNavigator } from '@react-navigation/stack';
import Monthly from './Monthly';

function MainScreen({ navigation }) {
  const [number, onChangeNumber] = React.useState(null);
  return (
    <>
      <View>
        <Text style={style.Font}>여기는 메인 페이지 입니다.</Text>
        <Text style={style.Font}>아래는 input 테스트를 위한 것입니다.</Text>
        <TextInput
          style={style.TextInput}
          onChangeText={onChangeNumber}   
          keyboardType="numeric"
        />
        <Text>입력한 숫자 보기: {number} </Text>
      </View>
      <Button
        title="월별 페이지로 이동"
        onPress={() => navigation.navigate('Monthly')}
      /> 
    </> 
  )
}

const Stack = createStackNavigator();

function App4() {
  return (
    <NavigationContainer>
      <Stack.Navigator initialRouteName="Main">
        <Stack.Screen name="Main" component={MainScreen} />
        <Stack.Screen name="Monthly" component={Monthly} />
      </Stack.Navigator>
    </NavigationContainer>
  );
}

const style = StyleSheet.create({
  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  }
});
export default App4;
