import React, {useState} from 'react' ;
import {StyleSheet, Text, View, FlatList, TouchableOpacity} from 'react-native';
import { LongPressGestureHandler } from 'react-native-gesture-handler';
//ScrollView를 해야 밑에 내릴 수 있음
export default function App() {
    const [people, setPeople] = useState([
        { name : 'shaun', id: '1'},
        { name : 'yoshi', id: '2'},
        { name : 'shaun', id: '3'},
        { name : 'shaun', id: '4'},
        { name : 'shaun', id: '5'},
        { name : 'shaun', id: '6'},
        { name : 'shaun', id: '7'},
    ]);

    const pressHandler = (id) => {
        console.log(id);
        setPeople((prevPeople) => {
            return prevPeople.filter(person => person.id != id);
        });
    }

return (
    <View style = {styles.container}>
            <FlatList
            numColumns={2}
            keyExtractor = {(item) => item.id}
            data = {people}
            renderItem = {({item}) => (
                <TouchableOpacity OnPress = {()  => LongPressGestureHandler(item.id)}>
                    <Text style = {styles.item} > {item.name}</Text>
                </TouchableOpacity>
                
            )}
            />

    </View>
    ); //key를 나타내어주어야 error가 안뜸 
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#fff',
        paddingTop: 40,
        paddingHorizontal: 20 
    },
    item: {
        marginTop: 24,
        padding:30,
        backgroundColor: 'pink',
        fontSize: 24,
        marginHorizontal: 10,
        marginTop: 24,
    } //세로간격 나누기
});