import * as React from 'react';
import { StyleSheet, View, Text, TextInput, Button, Keyboard, TouchableWithoutFeedback } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
import Analy from './Analy';
import MoneyDB from './MoneyDB';


const DismissKeyboard = ({ children }) => (
  <TouchableWithoutFeedback onPress={() => Keyboard.dismiss()} >
    {children}
  </TouchableWithoutFeedback>

);


function MainScreen({ navigation }) {
  const [number, onChangeNumber] = React.useState(null);
  return (
    <>
      <View>
        <Text style={style.Font}>여기는 메인 페이지 입니다.</Text>
        <Text style={style.Font}>아래는 input 테스트를 위한 것입니다.</Text>
        <TextInput
          style={style.TextInput}
          onChangeText={onChangeNumber}
          keyboardType="numeric"
        />
        <Text>입력한 숫자 보기: {number} </Text>
      </View>
      <Button
        title="월별 페이지로 이동"
        onPress={() => navigation.navigate('Monthly')}
      />
      <MoneyDB />
    </>
  )
}



const Tab = createBottomTabNavigator();

function App() {
  return (
    <DismissKeyboard>
      <NavigationContainer>
        <Tab.Navigator screenOptions={({ route }) => ({
          tabBarIcon: ({ focused, color, size }) => {
            let iconName;

            if (route.name === 'Main') {
              iconName = focused ? 'home' : 'home-outline';
            } else if (route.name === 'Monthly') {
              iconName = focused ? 'calendar' : 'calendar-outline';
            } else if (route.name === 'Analy') {
              iconName = focused ? 'bar-chart' : 'bar-chart-outline';
            }
            // You can return any component that you like here!
            return <Ionicons name={iconName} size={size} color={color} />;
          },
        })}
          tabBarOptions={{
            activeTintColor: 'tomato',
            inactiveTintColor: 'gray',
          }}>
          <Tab.Screen name="Main" component={MainScreen} />
          <Tab.Screen name="Monthly" component={Monthly} />
          <Tab.Screen name="Analy" component={Analy} />
        </Tab.Navigator>
      </NavigationContainer>
    </DismissKeyboard>
  );
}

const style = StyleSheet.create({
  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  }
});
export default App;
