import React, { useEffect, useState } from 'react';
import { StyleSheet, View, TouchableWithoutFeedback, Keyboard } from 'react-native';
import InputBox from '../components/InputBox';
import StyledButton from '../components/StyledButton';
import DatePicker from '../components/DatePicker.js';
import deptApi from '../db/deptPage.api';
import { getDateStr } from '../utils/dateFunction';

function DeptDetails({ route, navigation }) {
    const { item, loadLoan } = route.params
    const getDates = () => {
        const date = new Date();
        return (getDateStr(date))
    }
    const [date, setDate] = useState(getDates())
    const [message, setMessage] = useState('')
    const [money, setMoney] = useState('')
    const [remained_money, setRemained_money] = useState('')

    useEffect(() => {
        setDate(String(item.date))
        setMessage(item.message)
        setMoney(String(item.money))
        setRemained_money(String(item.remained_money))
    }, [])

    const onUpdateHandle = async () => {
        await deptApi.updateDept({ date, message, money, remained_money }, item.id)
        loadLoan()
        navigation.navigate('DeptPage')
    }
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={{ flex: 1 }}>
                <View style={style.Font}>
                    <DatePicker
                        inputTitle="날짜"
                        date={date}
                        setDate={setDate}
                    />
                    <InputBox
                        inputTitle="내용"
                        value={message}
                        onChangeText={
                            (message) => setMessage(message)
                        }
                    />
                    <InputBox
                        inputTitle="금액"
                        value={money}
                        onChangeText={
                            (money) => setMoney(money)
                        }
                    />
                    <InputBox
                        inputTitle="남은 금액"
                        value={remained_money}
                        onChangeText={
                            (remained_money) => setRemained_money(remained_money)
                        }
                    />
                </View>
                <View style={style.buttonRow}>
                    <StyledButton
                        name="수정"
                        onPress={() => { onUpdateHandle() }}
                        style={style.submitButton}
                    />
                </View>
            </View>
        </TouchableWithoutFeedback>
    )
}

const style = StyleSheet.create({

    Font: {
        fontFamily: 'GowunDodum-Regular'
    },

    buttonRow: {
        fontFamily: 'GowunDodum-Regular',
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
    },
    submitButton: {
        flex: 1,
        height: 50,
    },
    cancelButton: {
        flex: 1,
        height: 50,
    }
});

export default DeptDetails;