import React, { useEffect, useState } from 'react';
import { StyleSheet, View, FlatList, TouchableOpacity, Modal, TouchableWithoutFeedback, Keyboard } from 'react-native';
import TodoItem from './components/TodoItem';
import Ionicons from 'react-native-vector-icons/Ionicons';
import MemoForm from './screens/MemoForm';
import memoApi from './db/memoPage.api';

function MemoPage({ navigation }) {
    const [memos, setMemos] = useState([]);
    const [modalOpen, setModalOpen] = useState(false);

    const loadMemos = async () => {
        try {
            const memoArray = await memoApi.selectMemo()
            console.log('memoload', memoArray)
            setMemos(memoArray);
        } catch (error) {
            console.log('error in load memos ( MemoPage.js )', error)
        }
    }

    const addInfo = async (info) => {
        await memoApi.insertMemo(info)
        setModalOpen(false);
        loadMemos();
    }

    const onDeleteHandle = async (id) => {
        await memoApi.deleteMemo(id)
        loadMemos();
    }

    useEffect(() => {
        loadMemos()
    }, [])

    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View Style={style.container}>
                <View style={{ width: '100%', height: '95%' }} >
                    <View style={{ width: '100%', height: '80%' }}>
                        <View >
                            <FlatList
                                data={memos}
                                renderItem={({ item }) => (
                                    <TouchableOpacity onPress={() => navigation.navigate('MemoDetails', {item : item, loadMemos : loadMemos})}>
                                        <TodoItem item={item} onDeleteHandle={() => onDeleteHandle(item.id)} />
                                    </TouchableOpacity>
                                )}
                            />
                        </View>
                    </View>
                    <Ionicons
                        name='add'
                        size={24}
                        style={style.modalToggle}
                        onPress={() => setModalOpen(true)}
                    />
                </View>
                <View>
                    <Modal visible={modalOpen} animationType='slide'>
                        <View style={style.modalContent}>
                            <Ionicons
                                name='close'
                                size={24}
                                style={style.modalToggle}
                                onPress={() => setModalOpen(false)}
                            />
                            <MemoForm addInfo={addInfo} />
                        </View>
                    </Modal>
                </View>
            </View>
        </TouchableWithoutFeedback >
    );
}






const style = StyleSheet.create({
    container: {
        flex: 1,
        width: '100%',
    },
    modalToggle: {
        borderWidth: 1,
        borderColor: 'gray', //gray
        padding: 5,
        borderRadius: 10,
        alignSelf: 'center', //위치를 center로
    },

    modalContent: {
        flex: 1,
    },

    TextInput: {
        borderColor: 'skyblue',
        height: 40,
        margin: 12,
        borderWidth: 1
    },
    Font: {
        fontSize: 24
    }
});

export default MemoPage;
