import React, { useEffect, useState } from 'react';
import { View, Text, StyleSheet, FlatList, Modal, Pressable } from 'react-native';
import editApi from './db/editOption.api';
import AntDesign from 'react-native-vector-icons/AntDesign';
import InputBox from './components/InputBox';
import StyledButton from './components/StyledButton';
import Accordion, { AccordionItem } from './components/Accordion';

const INIT_OPTION = { id: 0, value: '' }
const INIT_SUBOPTION = { id: 0, value: '', foreign_id: 0 }

const EditOption = ({ route }) => {
  console.log('catEdit: type_id ', route.params)
  const type = route.params ? 'category' : 'asset'
  const type_id = route.params

  const [options, setOptions] = useState([])
  const [option, setOption] = useState(INIT_OPTION)

  const [modalOpen, setModalOpen] = useState(false)
  const modalClose = () => { setModalOpen(false); setOption(INIT_OPTION) }

  const [error, setError] = useState("");
  const [loading, setLoading] = useState(false);

  useEffect(() => {
    loadOptions()
  }, [])

  const loadOptions = async () => {
    try {
      let optionArray = []
      if (type === 'asset') {
        optionArray = await editApi.selectAssetsType()
      } else if (type === 'category') {
        optionArray = await editApi.selectCategories(type_id)
      }
      setOptions(optionArray)
    } catch (error) {

    }
  }

  const handleUpdate = async () => {
    try {
      if (type === 'asset') {
        const res = await editApi.updateOption('assets_type', { id: option.id, name: 'assets', value: option.value })
        console.log(res)
      } else if (type === 'category') {
        if (option.foreign_id && option.foreign_id > 0) {
          const res = await editApi.updateOption('subcategories', { id: option.id, name: 'subcategory', value: option.value })
          return console.log(res)
        }
        const res = await editApi.updateOption('categories', { id: option.id, name: 'category', value: option.value })
        console.log(res)
      }
    } catch (error) {
      
    } finally {
      loadOptions()
      modalClose()
    }
  }

  const handleDelete = async (item) => {
    try {
      if (type === 'asset') {
        const res = await editApi.deleteOption('assets_type', { id: item.id, name: 'assets' })
        console.log(res)
      } else if (type === 'category') {
        if (item.foreign_id && item.foreign_id > 0) {
          const res = await editApi.deleteOption('subcategories', { id: item.id, name: 'subcategory'})
          return console.log(res)
        }
        const res = await editApi.deleteOption('categories', { id: item.id, name: 'category' })
        console.log(res)
      }
    } catch (error) {
      
    } finally {
      loadOptions()
    }
  }

  const handleAdd = async () => {
    try {
      if (type === 'asset') {
        const res = await editApi.addOption('assets_type', { name: 'assets', value: option.value })
        console.log(res)
      } else if (type === 'category') {
        if (option.foreign_id && option.foreign_id > 0) {
          const res = await editApi.addOption('subcategories', { name: 'subcategory', value: option.value, foreign_name: 'category', foreign_id: option.foreign_id })
          return console.log(res)
        }
        const res = await editApi.addOption('categories', { name: 'category', value: option.value, foreign_name: 'type', foreign_id: type_id })
        console.log(res)
      }
    } catch (error) {
      
    } finally {
      loadOptions()
      modalClose()
    }
  }

  const renderAssetItem = ({ item }) => (
    <View style={[style.flexRow, style.catBox]}>
      <View style={style.flexRow}>
        {item.deletable && <AntDesign name='minuscircle' style={style.cancelIcon} onPress={() => { handleDelete(item) }} />}
        <Text style={style.optionText} >
          {item.value}
        </Text>
      </View>
      {item.deletable && <AntDesign name='edit' style={style.icon} onPress={() => { setOption(item); setModalOpen(true) }} />}
    </View>
  );

  const renderCatItem = ({ item }) => (
    <Accordion
      title={item.value}
      left={item.deletable && <AntDesign name='closecircle' style={style.cancelIcon} onPress={() => { handleDelete(item) }} />}
      right={item.deletable && <AntDesign name='edit' style={style.icon} onPress={() => { setOption(item); setModalOpen(true) }} />}
      titleStyle={style.optionText}
      backgroundColor='lightgray'
    >
      {item.subOptions.length !== 0 &&
        <FlatList
          data={item.subOptions}
          renderItem={({ item }) => (
            <AccordionItem
              title={item.value}
              left={<AntDesign name='closecircle' style={style.cancelIcon} onPress={() => { handleDelete(item) }} />}
              right={<AntDesign name='edit' style={style.icon} onPress={() => { setOption(item); setModalOpen(true) }} />}
              titleStyle={style.optionText}
              backgroundColor='#b0b0b0'
              marginLeft={30}
            />
          )}
          keyExtractor={item => item.id.toString()}
        />
      }
      <Pressable
        style={[style.flexRow, { backgroundColor: "#b0b0b0", paddingVertical: 10 }]}
        onPress={() => {
          setOption({...INIT_SUBOPTION, ['foreign_id']: item.id});
          setModalOpen(true)
        }}
      >
        <AntDesign name='plus' style={[style.addIcon, { marginLeft: 35 }]} />
        <Text style={style.optionText} >추가하기</Text>
      </Pressable>
    </Accordion>
  );

  return (
    <>
      {console.log(option)}
      <View>
        <FlatList
          data={options}
          renderItem={type === 'asset' ? renderAssetItem : renderCatItem}
          keyExtractor={item => item.id.toString()}
        />
        <Pressable style={style.addButton} onPress={() => setModalOpen(true)}>
          <AntDesign name='plus' style={style.icon} />
          <Text style={style.optionText} >추가하기</Text>
        </Pressable>
      </View>

      <Modal
        transparent
        swipeDirection="down"
        animationType_id="fade"
        visible={modalOpen}
        onRequestClose={modalClose}
      >
        <View style={style.modalContainer}>
          <View style={style.modalHeader}>
            <View style={{ flexDirection: "row" }}>
              <AntDesign name='caretleft' style={style.icon} onPress={() => modalClose()} />
              <Text style={style.Font}>{option.id === 0 ? '추가' : '수정'}</Text>
            </View>
          </View>
          <View style={style.modalBody}>
            <InputBox
              placeholder="이름을 입력하세요."
              onChangeText={
                (name) => setOption({ ...option, value: name })
              }
              value={option.value}
              maxLength={30}
            />
            <View style={style.buttonRow}>
              <StyledButton
                name="저장하기"
                onPress={option.id === 0 ? handleAdd : handleUpdate}
                style={style.submitButton}
              />
            </View>
          </View>
        </View>
      </Modal>
    </>

  )
}

const style = StyleSheet.create({
  flexRow: {
    flexDirection: 'row',
  },
  flexCenter: {
    justifyContent: 'center',
    alignItems: 'center',
  },
  catBox: {
    justifyContent: 'space-between',
    paddingVertical: 10,
    backgroundColor: 'lightgray',
  },
  Font: {
    fontSize: 24
  },
  icon: {
    marginHorizontal: 5,
    fontSize: 30,
    color: 'black',
  },
  addIcon: {
    marginHorizontal: 5,
    fontSize: 25,
    color: 'black',
  },
  cancelIcon: {
    marginHorizontal: 5,
    fontSize: 25,
    color: 'red',
  },
  rightIcon: {
    marginHorizontal: 5,
    fontSize: 20,
    color: 'black',
  },
  optionText: {
    fontSize: 20,
    marginHorizontal: 10,
  },
  addButton: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    paddingVertical: 10,
    backgroundColor: 'gray',
    margin: 15
  },
  modalContainer: {
    flex: 1,
    backgroundColor: 'white',
  },
  modalHeader: {
    padding: 10,
  },
  modalBody: {

  },
  buttonRow: {
    flexDirection: 'row',
    alignItems: "center",
    marginHorizontal: 10,
    marginVertical: 3,
  },
  submitButton: {
    flex: 1,
    height: 50,
  },
});

export default EditOption;