import React from 'react';
import { View, Text, StyleSheet, Dimensions } from 'react-native';
import { BarChart } from "react-native-chart-kit";
import { Button } from 'react-native-elements';
import Ionicons from 'react-native-vector-icons/Ionicons';

const screenWidth = Dimensions.get("window").width;
const screenHeight = Dimensions.get("window").height;

const ChartY = ({ resDataY, year, setYear }) => {

  const chartConfig = {
    backgroundGradientFrom: "#ffffff", //좌측 색
    backgroundGradientFromOpacity: 1,
    backgroundGradientTo: "#ffffff", // 우측 색
    backgroundGradientToOpacity: 1,
    color: (opacity = 1) => `rgba(48, 48, 48, ${opacity})`,
    strokeWidth: 2, // optional, default 3
    barPercentage: 0.5, // 그래프 width
    useShadowColorFromDataset: false,// optional, default is false
    fillShadowGradientOpacity: 1,
  };
  const prevBtn = () => {
    setYear(year - 1)
  };
  const nextBtn = () => {
    setYear(year + 1)
  }

  const convertY = (y) => {
    let res = '';
    if (y >= 1000000000) {
      res = (y / 1000000000).toFixed(2) + "B"
    } else if (y >= 1000000) {
      res = (y / 1000000).toFixed(2) + "M"
    } else if (y >= 1000) {
      res = (y / 1000).toFixed(2) + "K"
    }
    return res
  }

  let totalYI = (resDataY.temp1[0].datasets[0].data).reduce((acc, curr) => acc + curr, 0);
  let totalYO = (resDataY.temp2[0].datasets[0].data).reduce((acc, curr) => acc + curr, 0);

  return (
    <>
      <View style={{ flexDirection: 'row' }}>
        <Button icon={
          <Ionicons name='chevron-back-sharp' onPress={prevBtn} size={15} color='black' />
        } type='clear' />
        <Text style={{ fontFamily: 'GowunDodum-Regular' }}>{year}년</Text>
        <Button icon={
          <Ionicons name='chevron-forward-sharp' onPress={nextBtn} size={15} color='black' />
        } type='clear' />
      </View>
      <View style={{ flexDirection: 'row', justifyContent: "space-around" }}>
        <Text style={[{ color: '#1E90FF' }, style.Font]}>수입:  {(totalYI).toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}원</Text>
        <Text style={[{ color: '#dc143c' }, style.Font]}>지출:  {(totalYO).toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}원 </Text>
      </View>
      <View>
        <BarChart
          style={{ marginBottom: "2%", marginTop: "2%" }}
          data={resDataY.temp1[0]}
          width={screenWidth}
          height={screenHeight / 3}
          chartConfig={{ ...chartConfig, fillShadowGradient: '#1E90FF', formatYLabel: convertY }}
          fromZero={true}
        />
        <BarChart
          style={{ marginTop: "2%" }}
          data={resDataY.temp2[0]}
          width={screenWidth}
          height={screenHeight / 3}
          chartConfig={{ ...chartConfig, fillShadowGradient: '#DC143C', formatYLabel: convertY }}
          fromZero={true}
        />
      </View>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    textAlign: "center",
    fontSize: 20,
    fontFamily: 'GowunDodum-Regular'
  },
});

export default ChartY;