import React, { useEffect, useState } from 'react';
import { SafeAreaView, View, Text, StyleSheet, FlatList } from 'react-native';
import calApi from './db/calendarInfo.api';

const DetailItem = ({ item }) => {

  return (
    <>
      <View style={{
        flexDirection: "row", padding: "5%", borderColor: '#d3d3d3', //light grey
        borderWidth: 1, borderTopWidth: 0,
      }}>
        <Text style={[style.itemText, item.type === 1 ? style.inputColor : style.outputColor]}>{item.category}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{item.contents}</Text>
        <Text style={[style.itemTextNum, style.Font]}>{item.price}원</Text>
      </View>
    </>
  );
};

const DetailInfo = ({ route }) => {
  console.log('route', route.params)
  console.log('---------------------------')
  const [resData, setResData] = useState([])
  const getDetailData = async () => {
    try {
      const resdata = await calApi.detailData({ findDate: route.params })
      console.log('resdata', resdata)
      setResData(resdata)
    } catch (error) {
      console.log('error in getDetailData', error)
    }
  }
  const renderDetail = ({ item }) => {
    return (
      <DetailItem item={item} />
    )
  }
  useEffect(() => {
    getDetailData()
  }, [])
  return (
    <>
      <SafeAreaView>
        {
          resData.length != 0 ? <FlatList
            data={resData}
            renderItem={renderDetail}
            keyExtractor={item => item.id}
          /> : <View style={{ marginTop: "20%" }}>
            <Text style={{ textAlign: "center", fontSize: 20, fontFamily: 'GowunDodum-Regular' }}>내역이 없습니다.</Text>
          </View>
        }
      </SafeAreaView>
    </>
  )
}
const style = StyleSheet.create({
  Font: {
    fontSize: 20,
    color: '#424242'
  },
  inputColor: {
    color: '#1E90FF'
  },
  outputColor: {
    color: '#dc143c'
  },
  itemTextNum: {
    flex: 1,
    textAlign: "center",
    fontFamily: 'GowunDodum-Regular'
  },
  itemText: {
    flex: 1,
    fontFamily: 'GowunDodum-Regular'
  }
});

export default DetailInfo;