import React, { Component } from 'react';
import { View, Text, Button, StyleSheet } from 'react-native';
import CalendarStrip from 'react-native-calendar-strip';
// import moment from 'moment';

const WeeklyCalendar = (props) => {


    return (
        <View>
            <CalendarStrip
                scrollable
                calendarAnimation={{ type: 'sequence', duration: 30 }}
                daySelectionAnimation={{ type: 'background', duration: 300, highlightColor: '#9265DC' }}
                style={{ height: 200, paddingTop: 20, paddingBottom: 10 }}
                calendarHeaderStyle={{ color: 'white' }}
                calendarColor={'#3343CE'}
                dateNumberStyle={{ color: 'white' }}
                dateNameStyle={{ color: 'white' }}
                iconContainer={{ flex: 0.1 }}
                // customDatesStyles={this.state.customDatesStyles}
                highlightDateNameStyle={{ color: 'white' }}
                highlightDateNumberStyle={{ color: 'yellow' }}
                highlightDateContainerStyle={{ backgroundColor: 'black' }}
                // markedDates={this.state.markedDates}
                // datesBlacklist={this.datesBlacklistFunc}
                // selectedDate={this.state.selectedDate}
                // onDateSelected={this.onDateSelected}
                useIsoWeekday={false}
            />
        </View>
    );
};

const style = StyleSheet.create({
    container: {
        height: 54,
        flexDirection: 'row',
        alignItems: "center",
        marginHorizontal: 10,
        marginVertical: 3,
        borderWidth: 1.5,
        borderStyle: "solid",
        borderColor: "#1467ff",
        borderRadius: 5,
        backgroundColor: "#f5f5f5",
    },
})

export default WeeklyCalendar