import React, { useState } from 'react';
import { StyleSheet, Button, View, Text, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';
import DatePicker from '../components/DatePicker.js';
import InputBox from '../components/InputBox.js';

const ReviewSchema = yup.object({
    // date: yup.string() //string만 받는다
    //     .required()  //아무것도 입력안했하면 안받음
    // ,  //최소4글짜
    message: yup.string()
        .required()
        .min(2),

})

const getDate = () => {
    var date = new Date();
    return (String(date.toJSON()).split(/T/)[0])
}


function MemoForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: '', message: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {//위의 4개의 val들을 전달

                        addInfo(values);
                    }}

                >
                    {({ handleChange, handleSubmit, values }) => (
                        <View>
                            <DatePicker
                                inputTitle='날짜'
                                date={values.date || getDate()}//오늘날짜 아니면 바뀐날짜
                                setDate={handleChange('date')}
                            />
                            <InputBox
                                inputTitle="내용"
                                onChangeText={handleChange('message')}
                                value={values.message}

                            />

                            <View style={{ marginVertical: '10%', marginHorizontal: 10 }}>
                                <Button title='입력' color='dodgerblue' onPress={handleSubmit} />
                            </View>
                        </View>
                    )}

                </Formik>

            </View >
        </TouchableWithoutFeedback>
    )
}

export default MemoForm;