import React from 'react';
import { ButtonGroup } from 'react-native-elements';
import { StyleSheet, Text } from 'react-native';

const ButtonsForm = (props) => {

    const component1 = () => <Text>{props.group[0]}</Text>
    const component2 = () => <Text>{props.group[1]}</Text>
    const component3 = () => <Text>{props.group[2]}</Text>

    return (
        <ButtonGroup
            onPress={props.onPress}
            selectedIndex={props.selectedIndex}
            buttons={[{ element: component1 }, { element: component2 }, { element: component3 }]}
            containerStyle={style.container}
            selectedButtonStyle={style.selectedButton}
            selectedTextStyle={style.selectedText}
        />
    );
};

const style = StyleSheet.create({
    container: {
        height: 50,
        flexDirection: 'row',
        alignItems: "center",
        backgroundColor: "#f5f5f5",
    },
    text: {
        color: "#808080",
        fontSize: 24
    },
    selectedButton: {
        backgroundColor: "#adadad",
    },
    selectedText: {
        color: "#1467ff",
        fontWeight: "bold",
    },
})

export default ButtonsForm