import React, { useState } from 'react';
import { StyleSheet, View, Text, TextInput, Button } from 'react-native';
import { NavigationContainer } from '@react-navigation/native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import Ionicons from 'react-native-vector-icons/Ionicons';
import Monthly from './Monthly';
// import Analy from './Analy';
import Calendar from './Calendar';
import PostMoney from './PostMoney';
import InsertCat from './InsertCat';

function MainScreen({ navigation }) {
  const [number, onChangeNumber] = useState(null)
  const [totalAssets, setTotalAssets] = useState(0) //총 자산

  return (
    <>
      <View>
        <Text style={style.Font}>주간 캘린더 들어올 자리</Text>
        <View style={style.Contents}>
          <Text style={style.Font}>총 자산</Text>
          <Text style={style.Font}>{totalAssets}원</Text>
        </View>
        <TextInput
          style={style.TextInput}
          onChangeText={onChangeNumber}
          keyboardType="numeric"
        />
        <Text>입력한 숫자 보기: {number} </Text>
      </View>
      <Button
        title="월별 페이지로 이동"
        onPress={() => navigation.navigate('Monthly')}
      />
      <InsertCat />
    </> 
  )
}

const Tab = createBottomTabNavigator();

function App() {
  return (
    <NavigationContainer>
      <Tab.Navigator screenOptions={({ route }) => ({
        tabBarIcon: ({ focused, color, size }) => {
          let iconName;

          if (route.name === 'Main') {
            iconName = focused
              ? 'home'
              : 'home-outline';
          } else if (route.name === 'Monthly') {
            iconName = focused ? 'calendar' : 'calendar-outline';
          } else if (route.name === 'Analy') {
            iconName = focused ? 'bar-chart' : 'bar-chart-outline';
          } else if (route.name === 'Calendar') {
            iconName = focused ? 'calendar-sharp':'calendar-sharp';
          }

          // You can return any component that you like here!
          return <Ionicons name={iconName} size={size} color={color} />;
        },
      })}
        tabBarOptions={{
          activeTintColor: 'skyblue',
          inactiveTintColor: 'gray',
        }}>
        <Tab.Screen name="Main" component={MainScreen} />
        <Tab.Screen name="Monthly" component={Monthly} />
        <Tab.Screen name="Calendar" component={Calendar} />
        <Tab.Screen name="Analy" component={PostMoney} />
      </Tab.Navigator>
    </NavigationContainer>
  );
}

const style = StyleSheet.create({
  TextInput: {
    borderColor: 'skyblue',
    height: 40,
    margin: 12,
    borderWidth: 1
  },
  Font: {
    fontSize: 24
  },
  Contents: {
    justifyContent: "center",
    alignItems: "center",
    margin:10
  }
});
export default App;
