import React from 'react';
import { Button, View, TouchableWithoutFeedback, Keyboard } from 'react-native';
import { globalStyles } from '../styles/global.js'
import { Formik } from 'formik';
import * as yup from 'yup';
import DatePicker from '../components/DatePicker.js';
import InputBox from '../components/InputBox';
import { getDateStr } from '../utils/dateFunction';

const ReviewSchema = yup.object({
    date: yup.string()
        .required(),
    message: yup.string()
        .required()
        .min(2),
    money: yup.number()
        .required(),
    remained_money: yup.number()
        .required()
})

const getDates = () => {
    const date = new Date();
    return (getDateStr(date))
}

function DeptForm({ addInfo }) {
    return (
        <TouchableWithoutFeedback onPress={() => {
            Keyboard.dismiss();
        }}>
            <View style={globalStyles.container} >
                <Formik
                    initialValues={{ date: '', message: '', money: '', remained_money: '' }}
                    validationSchema={ReviewSchema}
                    onSubmit={(values) => {
                        addInfo(values);
                    }}
                >
                    {({ handleChange, handleSubmit, values }) => (
                        <View>
                            <DatePicker
                                inputTitle='날짜'
                                date={values.date || getDates()}
                                setDate={handleChange('date')}
                            />
                            <InputBox
                                inputTitle="내용"
                                onChangeText={handleChange('message')}
                                value={values.message}
                            />
                            <InputBox
                                inputTitle="금액"
                                onChangeText={handleChange('money')}
                                value={values.money}
                                keyboardType="numeric"
                            />
                            <InputBox
                                inputTitle="남은금액"
                                onChangeText={handleChange('remained_money')}
                                value={values.remained_money}
                                keyboardType="numeric"
                            />

                            <View style={{ marginVertical: '10%', marginHorizontal: 10 }}>
                                <Button title='입력' color='dodgerblue' onPress={handleSubmit} />
                            </View>

                        </View>
                    )}
                </Formik>
            </View >
        </TouchableWithoutFeedback>
    )
}

export default DeptForm;